<?php
/*
 *  $Id: Abstract.php 10831 2013-05-29 19:32:17Z btowles $
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information, see
 * <http://www.doctrine-project.org>.
 */

/**
 * Doctrine_Hydrator_Abstract
 *
 * @package     Doctrine
 * @subpackage  Hydrate
 * @license     http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @link        www.doctrine-project.org
 * @since       1.0
 * @version     $Revision: 3192 $
 * @author      Konsta Vesterinen <kvesteri@cc.hut.fi>
 */
abstract class Doctrine_Hydrator_Abstract extends Doctrine_Locator_Injectable
{
    protected
        $_queryComponents = array(),
        $_tableAliases = array(),
        $_priorRow,
        $_hydrationMode;

    public function __construct($queryComponents = null, $tableAliases = null, $hydrationMode = null)
    {
        $this->setQueryComponents($queryComponents);
        $this->setTableAliases($tableAliases);
        $this->setHydrationMode($hydrationMode);
    }

    /**
     * Set the query components (structure and query instructions)
     *
     * @param array $queryComponents
     * @return void
     */
    public function setQueryComponents($queryComponents)
    {
        $this->_queryComponents = $queryComponents;
    }

    /**
     * Set the table aliases for this query
     *
     * @param array $tableAliases
     * @return void
     */
    public function setTableAliases($tableAliases)
    {
        $this->_tableAliases = $tableAliases;
    }

    /**
     * Set the hydration mode
     *
     * @param mixed $hydrationMode  One of the Doctrine_Core::HYDRATE_* constants or
     *                              a string representing the name of the hydration mode or
     *                              or an instance of the hydration class
     * @return void
     */
    public function setHydrationMode($hydrationMode)
    {
        $this->_hydrationMode = $hydrationMode;
    }

    public function getRootComponent()
    {
        $queryComponents = array_values($this->_queryComponents);
        return $queryComponents[0]['table'];
    }

    public function onDemandReset()
    {
        $this->_priorRow = null;
    }

    /**
     * Checks whether a name is ignored. Used during result set parsing to skip
     * certain elements in the result set that do not have any meaning for the result.
     * (I.e. ORACLE limit/offset emulation adds doctrine_rownum to the result set).
     *
     * @param string $name
     * @return boolean
     */
    protected function _isIgnoredName($name)
    {
        return $name == 'DOCTRINE_ROWNUM';
    }

    /**
     * hydrateResultSet
     * parses the data returned by statement object
     *
     * This is method defines the core of Doctrine object population algorithm
     * hence this method strives to be as fast as possible
     *
     * The key idea is the loop over the rowset only once doing all the needed operations
     * within this massive loop.
     *
     * @param mixed $stmt
     * @return mixed
     */
    abstract public function hydrateResultSet($stmt);
}