<?php

/**
 * RokGallery_Model_FileTable
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class RokGallery_Model_FileTable extends RokCommon_Doctrine_Table
{
    /**
     * Returns an instance of this class.
     *
     * @return object RokGallery_Model_FileTable
     */
    public static function getInstance()
    {
        return Doctrine_Core::getTable('RokGallery_Model_File');
    }


    /**
     * @static
     * @throws Exception
     * @param  $id
     * @return RokGallery_Model_File
     */
    public static function getSingle($id)
    {
        try
        {
            $table = self::getInstance();
            return $table->find($id);
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @static
     * @throws Exception
     * @param  $id
     * @return RokGallery_Model_File
     */
    public static function getMD5($md5)
    {
        try
        {
            $table = self::getInstance();
            return $table->findByMd5($md5);
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * Returns the total number of files in the system
     * @return int;
     */
    public static function getTotalFileCount()
    {
        try
        {
            $table = self::getInstance();
            $q = $table->createQuery('f')
                ->select('COUNT(*) as files_count');
            $return = $q->fetchOne(array(), Doctrine_Core::HYDRATE_SINGLE_SCALAR);
            $q->free();
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param array $tags
     * @return Doctrine_Collection|bool
     */
    public static function getByTags(array $tags)
    {
        try
        {
            if (empty($tags)) return array();

            $table = self::getInstance();
            $q = $table->createQuery('f')
                ->leftJoin('f.Tags t')
                ->whereIn('t.tag', $tags);
            $return = $q->execute();
            $q->free();
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param array $tags
     * @return array|bool
     */
    public static function getIdsByTags(array $tags)
    {
        try
        {
            if (empty($tags)) return array();

            $table = self::getInstance();
            $q = $table->createQuery('f')
                ->select('f.id')
                ->from('RokGallery_Model_File f')
                ->leftJoin('f.Tags t')
                ->whereIn('t.tag', $tags);

            $return = $q->execute(array(), Doctrine_Core::HYDRATE_SINGLE_SCALAR);
            $q->free();
            if (!is_array($return)) {
                $return = array($return);
            }
            return $return;
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param \RokGallery_Model_File $file
     * @param array $tags
     */
    public static function addTagsToFile(RokGallery_Model_File &$file, array $tags = array())
    {
        try
        {
            foreach ($tags as $tag)
            {
                $found = false;
                foreach ($file->Tags as $current_tag)
                {
                    if (strtolower($tag) == $current_tag['tag']) {
                        $found = true;
                        continue 2;
                    }
                }

                $next = $file->Tags->count();
                $file->Tags[$next]['tag'] = $tag;

                $galleries = RokGallery_Model_GalleryTable::getByTag($tag);
                foreach ($galleries as $gallery) {
                    $file->updateSlicesForGallery($gallery);
                }

                // If a Slice has the same tag delete it   its moved to the file now
                $query = Doctrine_Query::create()
                    ->delete('RokGallery_Model_SliceTags st')
                    ->whereIn('st.slice_id', $file->Slices->getPrimaryKeys())
                    ->andWhere('st.tag = ?', $tag);
                $query->execute();
            }
            $file->save();
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }

    /**
     * @param \RokGallery_Model_File $file
     * @param array $tags
     */
    public static function removeTagsFromFile(RokGallery_Model_File &$file, array $tags = array())
    {
        try
        {
            $query = Doctrine_Query::create()
                ->delete('RokGallery_Model_FileTags ft')
                ->where('ft.file_id = ?', $file->id)
                ->andWhereIn('ft.tag', $tags);
            $query->execute();

            foreach ($tags as $tag)
            {
                $galleries = RokGallery_Model_GalleryTable::getByTag($tag);

                foreach ($galleries as $gallery) {
                    $slices = $file->getSlicesForGallery($gallery->id);
                    if (is_array($slices)) {
                        foreach ($slices as &$slice) {
                            if (RokGallery_Config::getOption(RokGallery_Config::OPTION_GALLERY_REMOVE_SLICES, false)) {
                                $file->unlink('Slices', array($slice->id));
                                $slice->delete();
                            }
                            else {
                                $slice->gallery_id = null;
                                $slice->save();
                            }
                        }
                    }
                }
            }
            $file->save();
        }
        catch (Exception $e)
        {
            throw $e;
        }
    }
}