<?php

/**
 * RokGallery_Model_Gallery
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    RokGallery
 * @subpackage models
 * @author     RocketTheme LLC <support@rockettheme.com>
 * @version    SVN: $Id: Gallery.php 10871 2013-05-30 04:06:26Z btowles $
 */
class RokGallery_Model_Gallery extends RokGallery_Model_Base_Gallery
{

	/**
	 * @param \Doctrine_Event $event
	 *
	 * @return void
	 */
    public function postDelete($event)
    {
        //Make sure all linked tables are clean
		$q = Doctrine_Query::create()->update('RokGallery_Model_Slice')->set('gallery_id', 'NULL')->andWhere('gallery_id NOT IN (SELECT g.id from RokGallery_Model_Gallery g)');
        $q->execute();
        $q->free();
    }

	/**
	 * @param \Doctrine_Event $event
	 *
	 * @return void
	 */
    public function preUpdate($event)
    {
        // set background color to transparent
        if (empty($this->thumb_background)) {
            $this->thumb_background = 'transparent';
        }
    }

	/**
	 * @param \Doctrine_Event $event
	 *
	 * @return void
	 */
    public function preInsert($event)
    {
        // set background color to transparent
        if (empty($this->thumb_background)) {
            $this->thumb_background = 'transparent';
        }
    }


    /**
     * Check to see if a gallery is for a particular filetag
	 *
     * @param $tag
	 *
     * @return bool
     */
    public function hasTag($tag)
    {
		foreach ($this->filetags as $filetag) {
            if ($tag == $filetag) {
                return true;
            }
        }
        return false;
    }

    public function setSliceOrder(array $slice_order)
    {
		$orderable_listener = null;
		$listeners          = $this->Slices->getTable()->getRecordListener();
		$i = 0;
		while ($listener = $listeners->get($i)) {
			if ($listener instanceof Doctrine_Template_Listener_Orderable) {
				$orderable_listener = $listener;
				break;
			}
			$i++;
		}
		if (!is_null($orderable_listener)) $orderable_listener->setOption('disabled', true);
        $this->Slices->setKeyColumn('id');
		foreach ($slice_order as $position => $slice_id) {
			foreach ($this->Slices as $ar_id => $slice) {
                    if ($slice->id == $slice_id) {
                    $slice->ordering = $position;
                    break;
                }
            }
        }
		$this->Slices->save();
		if (!is_null($orderable_listener)) $orderable_listener->setOption('disabled', false);
    }
}