-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 169, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":{"6":1},"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 18, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(8, 1, 19, 98, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 99, 100, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 101, 102, 1, 'com_installer', 'com_installer', '{"core.admin":[],"core.manage":{"7":0},"core.delete":{"7":0},"core.edit.state":{"7":0}}'),
(11, 1, 103, 104, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 105, 106, 1, 'com_login', 'com_login', '{}'),
(13, 1, 107, 108, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 109, 110, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 111, 112, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1}}'),
(16, 1, 113, 114, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 115, 116, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 117, 118, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 119, 122, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(20, 1, 123, 124, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 125, 126, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 127, 128, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 129, 130, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 131, 134, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(25, 1, 135, 140, 1, 'com_weblinks', 'com_weblinks', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(26, 1, 141, 142, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 21, 2, 'com_content.category.2', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(30, 19, 120, 121, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(31, 25, 136, 137, 2, 'com_weblinks.category.6', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(32, 24, 132, 133, 1, 'com_users.notes.category.7', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(33, 1, 143, 144, 1, 'com_finder', 'com_finder', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(34, 1, 145, 146, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{"core.admin":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}'),
(35, 1, 147, 148, 1, 'com_gantry', 'gantry', '{}'),
(36, 1, 149, 150, 1, 'com_rokcandy.category.8', 'Basic', ''),
(37, 1, 151, 152, 1, 'com_rokcandy.category.9', 'Typography', ''),
(38, 1, 153, 154, 1, 'com_rokcandy.category.10', 'Uncategorised', ''),
(39, 1, 155, 156, 1, 'com_rokcandy', 'rokcandy', '{}'),
(40, 1, 157, 158, 1, 'com_rokgallery', 'rokgallery', '{}'),
(41, 1, 159, 160, 1, 'com_roksprocket', 'roksprocket', '{}'),
(42, 8, 22, 45, 2, 'com_content.category.11', 'Demo Articles', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(43, 8, 46, 63, 2, 'com_content.category.12', 'Sample Content', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(44, 8, 64, 97, 2, 'com_content.category.13', 'RokSprocket Mosaic', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(45, 42, 23, 24, 3, 'com_content.article.1', 'Template Features', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(46, 42, 25, 26, 3, 'com_content.article.2', 'Module Positions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(47, 42, 27, 28, 3, 'com_content.article.3', 'Module Variations', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(48, 42, 29, 30, 3, 'com_content.article.4', 'Template Typography', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(49, 42, 31, 32, 3, 'com_content.article.5', 'Menu Options', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(50, 42, 33, 34, 3, 'com_content.article.6', 'Integrated Extensions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(51, 42, 35, 36, 3, 'com_content.article.7', 'Tutorials and Guides', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(52, 42, 37, 38, 3, 'com_content.article.8', 'Installation Instructions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(53, 42, 39, 40, 3, 'com_content.article.9', 'Logo Editing', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(54, 42, 41, 42, 3, 'com_content.article.10', 'Preset Styles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(55, 42, 43, 44, 3, 'com_content.article.11', 'About Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(56, 43, 47, 48, 3, 'com_content.article.12', 'Donec Nunc Magna Posuere', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(57, 43, 49, 50, 3, 'com_content.article.13', 'Lorem Ipsum Dolor Sit Amet', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(58, 43, 51, 52, 3, 'com_content.article.14', 'Vestibulum Dapibus Est Nulla', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(59, 43, 53, 54, 3, 'com_content.article.15', 'Nec Libero Laoreet Faucibus', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(60, 43, 55, 56, 3, 'com_content.article.16', 'Sed Imperdiet Ligula Nisi', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(61, 43, 57, 58, 3, 'com_content.article.17', 'Massa Diam Tristique Urna', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(62, 43, 59, 60, 3, 'com_content.article.18', 'Sapien Eros Consetur Dolor', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(63, 43, 61, 62, 3, 'com_content.article.19', 'Maecenas Varius Neque Nec', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(64, 44, 65, 66, 3, 'com_content.article.20', 'Flexible Layouts.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(65, 44, 67, 68, 3, 'com_content.article.21', 'Core Framework.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(66, 44, 69, 70, 3, 'com_content.article.22', 'Website Speed.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(67, 44, 71, 72, 3, 'com_content.article.23', 'Preset Styles.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(68, 44, 73, 74, 3, 'com_content.article.24', 'Powerful Menu.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(69, 44, 75, 76, 3, 'com_content.article.25', 'K2 Styling.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(70, 44, 77, 78, 3, 'com_content.article.26', '84 Positions.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(71, 44, 79, 80, 3, 'com_content.article.27', 'Logo Picker.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(72, 44, 81, 82, 3, 'com_content.article.28', 'RokSprocket.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(73, 44, 83, 84, 3, 'com_content.article.29', 'Tutorials.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(74, 44, 85, 86, 3, 'com_content.article.30', 'Module Variants.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(75, 44, 87, 88, 3, 'com_content.article.31', 'RokGallery.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(76, 44, 89, 90, 3, 'com_content.article.32', 'Mosaic Layout.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(77, 44, 91, 92, 3, 'com_content.article.33', 'FusionMenu.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(78, 44, 93, 94, 3, 'com_content.article.34', 'SplitMenu.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(79, 44, 95, 96, 3, 'com_content.article.35', 'Integrated Extensions.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(80, 25, 138, 139, 2, 'com_weblinks.category.14', 'RocketTheme', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(81, 7, 16, 17, 2, 'com_contact.category.15', 'RocketTheme', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(82, 1, 161, 162, 1, 'com_tags', 'com_tags', '{}'),
(83, 1, 163, 164, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(84, 1, 165, 166, 1, 'com_ajax', 'com_ajax', '{}'),
(85, 1, 167, 168, 1, 'com_postinstall', 'com_postinstall', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 29, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 402, '2009-10-18 16:07:09', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 402, '2010-06-28 13:26:37', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 402, '2010-06-28 13:27:35', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 402, '2010-06-28 13:27:57', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 402, '2010-06-28 13:28:15', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 9, 10, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 402, '2010-06-28 13:28:33', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 11, 12, 1, 'uncategorised', 'com_users.notes', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 402, '2010-06-28 13:28:33', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 36, 1, 13, 14, 1, 'basic', 'com_rokcandy', 'Basic', 'basic', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 402, '2012-08-09 11:04:06', 0, '0000-00-00 00:00:00', 0, '', 1),
(9, 37, 1, 15, 16, 1, 'typography', 'com_rokcandy', 'Typography', 'typography', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 402, '2012-08-09 11:04:06', 0, '0000-00-00 00:00:00', 0, '', 1),
(10, 38, 1, 17, 18, 1, 'uncategorised', 'com_rokcandy', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 402, '2012-08-09 11:04:06', 0, '0000-00-00 00:00:00', 0, '', 1),
(11, 42, 1, 19, 20, 1, 'demo-articles', 'com_content', 'Demo Articles', 'demo-articles', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 402, '2012-08-09 11:15:20', 0, '0000-00-00 00:00:00', 0, '*', 1),
(12, 43, 1, 21, 22, 1, 'sample-content', 'com_content', 'Sample Content', 'sample-content', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 402, '2012-08-09 11:15:29', 0, '0000-00-00 00:00:00', 0, '*', 1),
(13, 44, 1, 23, 24, 1, 'roksprocket-mosaic', 'com_content', 'RokSprocket Mosaic', 'roksprocket-mosaic', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 402, '2012-08-09 11:16:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(14, 80, 1, 25, 26, 1, 'rockettheme', 'com_weblinks', 'RocketTheme', 'rockettheme', '', '<div class="rt-image rt-floatleft">\r\n	<img alt="RocketTheme WebLinks" src="images/rocketlauncher/weblinks/rockettheme.png" />\r\n</div>\r\n\r\n<p>RocketTheme provides Premium Professional Themes and Templates for OpenSource Platforms: Joomla, Wordpress, phpBB3, Magento &amp; More</p>\r\n\r\n<p>The RocketTheme Template Club features exclusive access to professional templates to help transform your site &amp; set you apart from the competition.</p>\r\n\r\n<div class="clear"></div>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 402, '2012-08-09 12:06:03', 977, '2012-08-09 12:48:46', 0, '*', 1),
(15, 81, 1, 27, 28, 1, 'rockettheme', 'com_contact', 'RocketTheme', 'rockettheme', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 402, '2012-08-09 12:11:01', 0, '0000-00-00 00:00:00', 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Fracture', 'fracture', 'September 2012 Template Demo', '123 Fracture Boulevard', 'Seattle', 'WA', 'United States of America', '00000', '+1-555-555-555', '+1-555-555-555', 'September 2012 Template Demo', 'images/rocketlauncher/contact-us/fracture-contact.jpg', 'admin@demo.rockettheme.com', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":null,"linkb_name":"","linkb":null,"linkc_name":"","linkc":null,"linkd_name":"","linkd":null,"linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 15, 1, '+1-555-555-555', 'http://demo.rockettheme.com/?template=fracture', '', '', '', '*', '2012-08-09 12:16:01', 402, '', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(1, 45, 'Template Features', 'template-features', '<div class="rt-center">\r\n  <span class="promo3">The next generation layout and structure compliments the beautiful and intricate design of the template in conjunction with its many features and integrated extensions</span>\r\n</div>\r\n\r\n<br />\r\n\r\n<div class="rt-image rt-center largemargintop largemarginbottom">\r\n  <img src="images/rocketlauncher/features/features-template-preview.png" alt="image" />\r\n</div>\r\n\r\n<br />\r\n\r\n<div class="rt-center largemargintop largemarginbottom">\r\n  <span class="promo2">Inside <strong>Fracture</strong> Template</span><br />\r\n  <span class="promo3">Everything You Need to Build Your Stunning Website</span>\r\n</div>\r\n\r\n<br />\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-1.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117" target="_blank"><span>Preset Styles</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-2.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=2&amp;Itemid=109" target="_blank"><span>Modules Position</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-3.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=3&amp;Itemid=110" target="_blank"><span>Module Variations</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-4.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=112" target="_blank"><span>Mega Menu</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-5.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=4&amp;Itemid=111" target="_blank"><span>Typography</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-6.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=6&amp;Itemid=113" target="_blank"><span>Integrated Extensions</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-7.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=9&amp;Itemid=116" target="_blank"><span>Logo Picker</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-8.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=6&amp;Itemid=113" target="_blank"><span>K2 (3rd Party)</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33 rt-center">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/features/feature-9.jpg" alt="image" />\r\n      <h3><a href="index.php?option=com_content&amp;view=article&amp;id=11&amp;Itemid=118" target="_blank"><span>Joomla Stuff</span></a></h3>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div><br />\r\n\r\n<div class="rt-center largemargintop largemarginbottom">\r\n  <span class="promo2"><strong>Gantry 4</strong> Framework</span><br />\r\n  <span class="promo3">Powerful Framework that Makes Building Websites Easier</span>\r\n</div>\r\n\r\n<br />\r\n\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <ul class="list-icon info largemargintop">\r\n      <li class="largemarginbottom"><strong>Compact Grid System</strong><br />CSS grid framework to construct content by providing commonly used dimensions</li>\r\n      <li class="largemarginbottom"><strong>Stunning Admin Interface</strong><br />Gantry provides a uniquely intuitive interface to control all aspects of the design</li>\r\n      <li class="largemarginbottom"><strong>Multi-Page Configuration</strong><br />Assign different template configurations for one or several menu items/pages</li>\r\n    </ul>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image rt-center">\r\n      <img src="images/rocketlauncher/features/feature-admin-panel.png" alt="image" />\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n      <ul class="list-icon info largemargintop">\r\n        <li class="largemarginbottom"><strong>Source-Ordered Columns</strong><br />With up to 3 total sidebars, you can achieve highly complex mainbody layout scenarios</li>\r\n        <li class="largemarginbottom"><strong>Integrated Gantry Features</strong><br />Many built-in features such as font-sizer, Google Analytics, Date, etc</li>\r\n        <li class="largemarginbottom"><strong>Grid RTL Support</strong><br />Built in RTL support which will automatically order the layout to support RTL</li>\r\n      </ul>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div><br />\r\n\r\n<div class="rt-center largemargintop largemarginbottom">\r\n  <span class="promo2"><strong>Interested</strong>? Want to try <strong>Fracture</strong>?</span><br />\r\n  <a class="readon medmargintop" href="http://www.rockettheme.com/joomla-templates/fracture" target="_blank"><span><span class="icon-download-alt"></span>Download</span></a>\r\n</div>\r\n\r\n<div class="clear"></div><br />', '', 1, 11, '2012-08-09 11:23:45', 402, '', '2012-09-04 11:46:17', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:23:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 10, '', '', 1, 281, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(2, 46, 'Module Positions', 'module-positions', '<p class="notice">If no modules are published to a position, the entire area or row will not appear/collapse.</p>\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/module-positions/positions-diagram.jpg" alt="Module Positions" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div>\r\n\r\n<div class="rt-center medpaddingtop smallpaddingbottom"><a class="readon"  href="http://www.gantry-framework.org/documentation/joomla/configure/layouts"><span>Documentation: Gantry Framework Layouts</span></a></div>\r\n', '', 1, 11, '2012-08-09 11:24:32', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:24:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 9, '', '', 1, 87, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(3, 47, 'Module Variations', 'module-variations', '<p>There are <strong>9 stylistic module class suffixes</strong>, these add a unique style variation to the module: <strong>box1-5</strong> and <strong>title1-4</strong>; and 25 structural suffixes, these affect the layout and metrics of the module.</p>\n\n<p>Furthermore, you can also add <a href="http://fortawesome.github.com/Font-Awesome/">FontAwesome</a> icons into the center of the hex images for the <strong>title1-2</strong> suffixes. Suffixes are in the <strong>icon-NAME</strong> format such as <strong>icon-star</strong>, as shown on the <a href="index.php?option=com_content&amp;view=article&amp;id=4&amp;Itemid=111">Typography</a> page.</p>', '', 1, 11, '2012-08-09 11:30:11', 402, '', '2012-09-04 09:04:51', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:30:11', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 8, '', '', 1, 244, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(4, 48, 'Template Typography', 'template-typography', '<h4>Creating Beautiful Content With Simple Code</h4>\r\n\r\n<p>Typography is a fundamental part of a template, providing you with the tools to characterise your content and bring it to life. There is a vast array of typography available with the template, as is with our previous releases, from list styles, notice blocks and a diverse number of other elements. </p>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <h2>&lt;h1&gt; Heading Styles</h2>\r\n    \r\n    <h1>H1. Heading 1</h1>\r\n    <div class="clear"></div>\r\n    <h2>H2. Heading 2</h2>\r\n    <h3>H3. Heading 3</h3>\r\n    <h4>H4. Heading 4</h4>\r\n    <h5>H5. Heading 5</h5>\r\n    <h1 class="rt-pagetitle">H1. Page Title</h1>\r\n    <div class="clear"></div>\r\n    <h1 class="title nomarginbottom">H1. Content Title</h1>\r\n  </div>  \r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <h2>&lt;ul&gt; List Styles</h2>\r\n    \r\n    <ul>\r\n      <li><em>This is an example of a standard list style.</em> Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</li>\r\n      <li><em>This is an example of a standard list style.</em> Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</li>\r\n      <li><em>This is an example of a standard list style.</em> Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</li>\r\n      <li><em>This is an example of a standard list style.</em> Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</li>    \r\n      <li><em>This is an example of a standard list style.</em> Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</li>        \r\n    </ul>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">  \r\n    <h2>&lt;p&gt; DropCap Styles</h2>\r\n    \r\n    <p class="dropcap">Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibu. Pellentesque vel enim urna, sit amet blandit ipsum. Maecenas quis sem sit amet nunc pretium mattis. Sed dapibus semper est, sed pretium erat.</p>\r\n    \r\n    <p>Use the following format: <strong>&lt;p class="dropcap"&gt;...&lt;/p&gt; (HTML)</strong> or <strong>&#91;dropcap class="dropcap"&#93;...&#91;/dropcap&#93; (ROKCANDY)</strong>. You can use any letter, symbol or number.</p>\r\n    \r\n    <p class="dropcap2">Praesent rutrum sapien ac felis. Use this format: <strong>&lt;p class="dropcap2"&gt;...&lt;/p&gt; (HTML)</strong> or <strong>&#91;dropcap class="dropcap2"&#93; ... &#91;/dropcap&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p class="dropcap3">Praesent rutrum sapien ac felis. Use this format: <strong>&lt;p class="dropcap3"&gt;...&lt;/p&gt; (HTML)</strong> or <strong>&#91;dropcap class="dropcap3"&#93; ... &#91;/dropcap&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p class="dropcap4">Praesent rutrum sapien ac felis. Use this format: <strong>&lt;p class="dropcap4"&gt;...&lt;/p&gt; (HTML)</strong> or <strong>&#91;dropcap class="dropcap4"&#93; ... &#91;/dropcap&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p class="dropcap5 nomarginbottom">Praesent rutrum sapien ac felis. Use this format: <strong>&lt;p class="dropcap5"&gt;...&lt;/p&gt; (HTML)</strong> or <strong>&#91;dropcap class="dropcap5"&#93; ... &#91;/dropcap&#93; (ROKCANDY)</strong></p>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space"> \r\n    <h2>&lt;blockquote&gt;  Styles</h2>\r\n    \r\n    <blockquote><p>To replicate, use the following formatting: <strong>&lt;blockquote&gt;&lt;p&gt;....&lt;/p&gt;&lt;/blockquote&gt; (HTML)</strong> or <strong>&#91;blockquote class="default"&#93;...&#91;/blockquote&#93; (ROKCANDY)</strong>.</p></blockquote>\r\n    <br />\r\n    <blockquote class="alignleft"><p>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis.</p></blockquote>\r\n    \r\n    <p>To replicate, use the following formatting: <strong>&lt;blockquote class=&quot;alignleft&quot;&gt;&lt;p&gt;....&lt;/p&gt;&lt;/blockquote&gt; (HTML)</strong> or <strong>&#91;blockquote class="alignleft"&#93;...&#91;/blockquote&#93; (ROKCANDY)</strong>.</p>\r\n    \r\n    <p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Mauris metus tortor.</p>\r\n    <br />\r\n    <blockquote class="alignright nomarginbottom"><p>Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis.</p></blockquote>\r\n    \r\n    <p>To replicate, use the following formatting: <strong>&lt;blockquote class=&quot;alignright&quot;&gt;&lt;p&gt;....&lt;/p&gt;&lt;/blockquote&gt; (HTML)</strong> or <strong>&#91;blockquote class="alignright"&#93;...&#91;/blockquote&#93; (ROKCANDY)</strong>.</p>\r\n    \r\n    <p class="nomarginbottom">Lorem ipsum dolor sit amet, consecetur adipiscing elit. Mauris metus tortor.</p>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space"> \r\n    <h2>&lt;pre&gt; Code Styles</h2>\r\n    \r\n<pre class="lines">This is a sample <strong>&lt;pre class=&quot;lines&quot;&gt;...&lt;/pre&gt; (HTML)</strong> or,\r\n<strong>&#91;pre2 class="{lines}"&#93; ... &#91;/pre2&#93; (ROKCANDY)</strong> tag:\r\n\r\ndiv.modulebox-black div.bx1 {\r\n  background: url(../images/box_bl.png) 0 100% repeat;\r\n}\r\n\r\ndiv.modulebox-black div.bx2 {\r\n  background: url(../images/box_tr.png) 100% 0 repeat;\r\n}\r\n</pre>\r\n  \r\n<pre class="nomarginbottom">This is a sample <strong>&lt;pre&gt;...&lt;/pre&gt; (HTML)</strong> or,\r\n<strong>&#91;pre class="{lines}"&#93; ... &#91;/pre&#93; (ROKCANDY)</strong> tag:\r\n\r\ndiv.modulebox-black div.bx1 {\r\n  background: url(../images/box_bl.png) 0 100% repeat;\r\n}\r\n\r\ndiv.modulebox-black div.bx2 {\r\n  background: url(../images/box_tr.png) 100% 0 repeat;\r\n}\r\n</pre>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space"> \r\n    <h2>&lt;p&gt; Notice Styles</h2>\r\n    \r\n    <p class="approved">This is a <a href="javascript:void(0);">sample</a> of the <em>Approved</em> style. To replicate, use the following syntax: <em>&lt;p class="approved"&gt;....&lt;/p&gt;</em> (HTML) or <em>&#91;notice class="approved"&#93; <em class="normal">...</em> &#91;/notice&#93;</em> (ROKCANDY).</p>\r\n    \r\n    <p class="attention">This is a <a href="javascript:void(0);">sample</a> of the <em>Attention</em> style. To replicate, use the following syntax: <em>&lt;p class="attention"&gt;....&lt;/p&gt;</em> (HTML) or <em>&#91;notice class="attention"&#93; <em class="normal">...</em> &#91;/notice&#93;</em> (ROKCANDY).</p>\r\n    \r\n    <p class="notice">This is a <a href="javascript:void(0);">sample</a> of the <em>Notice</em> style. To replicate, use the following syntax: <em>&lt;p class="notice"&gt;....&lt;/p&gt;</em> (HTML) or <em>&#91;notice class="notice"&#93; <em class="normal">...</em> &#91;/notice&#93;</em> (ROKCANDY).</p>\r\n    \r\n    <p class="alert nomarginbottom">This is a <a href="javascript:void(0);">sample</a> of the <em>Alert</em> style. To replicate, use the following syntax: <em>&lt;p class="alert"&gt;....&lt;/p&gt;</em> (HTML) or <em>&#91;notice class="alert"&#93; <em class="normal">...</em> &#91;/notice&#93;</em> (ROKCANDY).</p>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space"> \r\n    <h2>&lt;span&gt; Text Icon</h2>\r\n    <p>To replicate, the following format: <strong>&lt;span class="text-icon iconname"&gt;...&lt;/span&gt; (HTML)</strong> or <strong>&#91;icon class=&quot;icon name&quot;&#93;...&#91;/icon&#93; (ROKCANDY)</strong>. The class names are listed below, such as "<strong>text-icon email</strong>".</p>\r\n    \r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <span class="text-icon email">Text with an email icon</span><br /><br />\r\n        <span class="text-icon phone">Text with a phone icon</span><br /><br />\r\n        <span class="text-icon quote">Text with a quote icon</span><br /><br />\r\n        <span class="text-icon cart">Text with a cart icon</span><br /><br />\r\n        <span class="text-icon rss">Text with a rss icon</span><br /><br />\r\n        <span class="text-icon tags">Text with a tags icon</span><br /><br />\r\n        <span class="text-icon write">Text with a write icon</span><br /><br />\r\n        <span class="text-icon info">Text with an info icon</span><br /><br />\r\n        <span class="text-icon sound">Text with a sound icon</span><br /><br />\r\n        <span class="text-icon rightarrow">Text with a rightarrow icon</span><br /><br />\r\n        <span class="text-icon leftarrow">Text with a leftarrow icon</span><br /><br />\r\n        <span class="text-icon circlearrow">Text with a circlearrow icon</span><br /><br />\r\n        <span class="text-icon downarrow">Text with a downarrow icon</span><br /><br />\r\n        <span class="text-icon uparrow">Text with an uparrow icon</span>\r\n      </div>\r\n    </div>\r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <span class="text-icon person">Text with a person icon</span><br /><br />\r\n        <span class="text-icon calendar">Text with a calendar icon</span><br /><br />\r\n        <span class="text-icon doc">Text with a doc icon</span><br /><br />\r\n        <span class="text-icon bulb">Text with a bulb icon</span><br /><br />\r\n        <span class="text-icon twitter">Text with a twitter icon</span><br /><br />\r\n        <span class="text-icon youtube">Text with a youtube icon</span><br /><br />\r\n        <span class="text-icon skype">Text with a skype icon</span><br /><br />\r\n        <span class="text-icon facebook">Text with a facebook icon</span><br /><br />\r\n        <span class="text-icon like">Text with a like icon</span><br /><br />\r\n        <span class="text-icon video">Text with a video icon</span><br /><br />\r\n        <span class="text-icon dropbox">Text with a dropbox icon</span><br /><br />\r\n        <span class="text-icon vimeo">Text with a vimeo icon</span><br /><br />\r\n        <span class="text-icon paypal">Text with a paypal icon</span>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <h2>&lt;em&gt; Emphasis Styles</h2>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="italic">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;italic&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;emphasis&#93;...&#91;/emphasis&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="bold">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;bold&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;emphasisbold&#93;...&#91;/emphasisbold&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="bold2">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;bold2&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;emphasisbold2&#93;...&#91;/emphasisbold2&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="highlight">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;default&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="highlight white">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight white&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;white&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="highlight black">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight black&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;black&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="highlight green">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight green&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;green&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="highlight yellow">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight yellow&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;yellow&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p>This is a emphasis tag that allows you to <em class="highlight blue">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight blue&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;blue&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n    \r\n    <p class="nomarginbottom">This is a emphasis tag that allows you to <em class="highlight red">highlight words or phrases</em>. Use the following format: <strong>&lt;em class=&quot;highlight red&quot;&gt;...&lt;/em&gt; (HTML)</strong> or <strong>&#91;highlight class=&quot;red&quot;&#93;...&#91;/highlight&#93; (ROKCANDY)</strong></p>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-demo-space">\r\n  <h2>Font Awesome Icons</h2>\r\n\r\n  <p>Font Awesome is a pictographic language of web-related actions which delivers 220 icons. The Font Awesome webfont, CSS, and LESS files are licensed under CC BY 3.0 and you can find the full examples of usage at <a href="http://fortawesome.github.com/Font-Awesome" target="_blank">Font Awesome - http://fortawesome.github.com/Font-Awesome</a></p>\r\n\r\n  <p>To replicate, use the following format: <strong>&lt;span class="<em>icon-name</em>"&gt;&lt;/span&gt;</strong> or <strong>&#91;span class=&quot;<em>icon-name</em>&quot;&#93;...&#91;/span&#93; (ROKCANDY)</strong>. The icons name are listed below, such as "<strong>icon-signal</strong>".</p>\r\n\r\n<h3>Web Icons</h3>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-adjust"> icon-adjust</span><br /><br />\r\n      <span class="icon-asterisk"> icon-asterisk</span><br /><br />\r\n      <span class="icon-ban-circle"> icon-ban-circle</span><br /><br />\r\n      <span class="icon-bar-chart"> icon-bar-chart</span><br /><br />\r\n      <span class="icon-barcode"> icon-barcode</span><br /><br />\r\n      <span class="icon-beaker"> icon-beaker</span><br /><br />\r\n      <span class="icon-bell"> icon-bell</span><br /><br />\r\n      <span class="icon-bolt"> icon-bolt</span><br /><br />\r\n      <span class="icon-book"> icon-book</span><br /><br />\r\n      <span class="icon-bookmark"> icon-bookmark</span><br /><br />\r\n      <span class="icon-bookmark-empty"> icon-bookmark-empty</span><br /><br />\r\n      <span class="icon-briefcase"> icon-briefcase</span><br /><br />\r\n      <span class="icon-bullhorn"> icon-bullhorn</span><br /><br />\r\n      <span class="icon-calendar"> icon-calendar</span><br /><br />\r\n      <span class="icon-camera"> icon-camera</span><br /><br />\r\n      <span class="icon-camera-retro"> icon-camera-retro</span><br /><br />\r\n      <span class="icon-certificate"> icon-certificate</span><br /><br />\r\n      <span class="icon-check"> icon-check</span><br /><br />\r\n      <span class="icon-check-empty"> icon-check-empty</span><br /><br />\r\n      <span class="icon-cloud"> icon-cloud</span><br /><br />\r\n      <span class="icon-cog"> icon-cog</span><br /><br />\r\n      <span class="icon-cogs"> icon-cogs</span><br /><br />\r\n      <span class="icon-comment"> icon-comment</span><br /><br />\r\n      <span class="icon-comment-alt"> icon-comment-alt</span><br /><br />\r\n      <span class="icon-comments"> icon-comments</span><br /><br />\r\n      <span class="icon-comments-alt"> icon-comments-alt</span><br /><br />\r\n      <span class="icon-credit-card"> icon-credit-card</span><br /><br />\r\n      <span class="icon-dashboard"> icon-dashboard</span><br /><br />\r\n      <span class="icon-download"> icon-download</span><br /><br />\r\n      <span class="icon-download-alt"> icon-download-alt</span><br /><br />\r\n      <span class="icon-edit"> icon-edit</span><br /><br />\r\n      <span class="icon-envelope"> icon-envelope</span><br /><br />\r\n      <span class="icon-envelope-alt"> icon-envelope-alt</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-exclamation-sign"> icon-exclamation-sign</span><br /><br />\r\n      <span class="icon-external-link"> icon-external-link</span><br /><br />\r\n      <span class="icon-eye-close"> icon-eye-close</span><br /><br />\r\n      <span class="icon-eye-open"> icon-eye-open</span><br /><br />\r\n      <span class="icon-facetime-video"> icon-facetime-video</span><br /><br />\r\n      <span class="icon-film"> icon-film</span><br /><br />\r\n      <span class="icon-filter"> icon-filter</span><br /><br />\r\n      <span class="icon-fire"> icon-fire</span><br /><br />\r\n      <span class="icon-flag"> icon-flag</span><br /><br />\r\n      <span class="icon-folder-close"> icon-folder-close</span><br /><br />\r\n      <span class="icon-folder-open"> icon-folder-open</span><br /><br />\r\n      <span class="icon-gift"> icon-gift</span><br /><br />\r\n      <span class="icon-glass"> icon-glass</span><br /><br />\r\n      <span class="icon-globe"> icon-globe</span><br /><br />\r\n      <span class="icon-group"> icon-group</span><br /><br />\r\n      <span class="icon-hdd"> icon-hdd</span><br /><br />\r\n      <span class="icon-headphones"> icon-headphones</span><br /><br />\r\n      <span class="icon-heart"> icon-heart</span><br /><br />\r\n      <span class="icon-heart-empty"> icon-heart-empty</span><br /><br />\r\n      <span class="icon-home"> icon-home</span><br /><br />\r\n      <span class="icon-inbox"> icon-inbox</span><br /><br />\r\n      <span class="icon-info-sign"> icon-info-sign</span><br /><br />\r\n      <span class="icon-key"> icon-key</span><br /><br />\r\n      <span class="icon-leaf"> icon-leaf</span><br /><br />\r\n      <span class="icon-legal"> icon-legal</span><br /><br />\r\n      <span class="icon-lemon"> icon-lemon</span><br /><br />\r\n      <span class="icon-lock"> icon-lock</span><br /><br />\r\n      <span class="icon-unlock"> icon-unlock</span><br /><br />\r\n      <span class="icon-magic"> icon-magic</span><br /><br />\r\n      <span class="icon-magnet"> icon-magnet</span><br /><br />\r\n      <span class="icon-map-marker"> icon-map-marker</span><br /><br />\r\n      <span class="icon-minus"> icon-minus</span><br /><br />\r\n      <span class="icon-minus-sign"> icon-minus-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-money"> icon-money</span><br /><br />\r\n      <span class="icon-move"> icon-move</span><br /><br />\r\n      <span class="icon-music"> icon-music</span><br /><br />\r\n      <span class="icon-off"> icon-off</span><br /><br />\r\n      <span class="icon-ok"> icon-ok</span><br /><br />\r\n      <span class="icon-ok-circle"> icon-ok-circle</span><br /><br />\r\n      <span class="icon-ok-sign"> icon-ok-sign</span><br /><br />\r\n      <span class="icon-pencil"> icon-pencil</span><br /><br />\r\n      <span class="icon-picture"> icon-picture</span><br /><br />\r\n      <span class="icon-plane"> icon-plane</span><br /><br />\r\n      <span class="icon-plus"> icon-plus</span><br /><br />\r\n      <span class="icon-plus-sign"> icon-plus-sign</span><br /><br />\r\n      <span class="icon-print"> icon-print</span><br /><br />\r\n      <span class="icon-pushpin"> icon-pushpin</span><br /><br />\r\n      <span class="icon-qrcode"> icon-qrcode</span><br /><br />\r\n      <span class="icon-question-sign"> icon-question-sign</span><br /><br />\r\n      <span class="icon-random"> icon-random</span><br /><br />\r\n      <span class="icon-refresh"> icon-refresh</span><br /><br />\r\n      <span class="icon-remove"> icon-remove</span><br /><br />\r\n      <span class="icon-remove-circle"> icon-remove-circle</span><br /><br />\r\n      <span class="icon-remove-sign"> icon-remove-sign</span><br /><br />\r\n      <span class="icon-reorder"> icon-reorder</span><br /><br />\r\n      <span class="icon-resize-horizontal"> icon-resize-horizontal</span><br /><br />\r\n      <span class="icon-resize-vertical"> icon-resize-vertical</span><br /><br />\r\n      <span class="icon-retweet"> icon-retweet</span><br /><br />\r\n      <span class="icon-road"> icon-road</span><br /><br />\r\n      <span class="icon-rss"> icon-rss</span><br /><br />\r\n      <span class="icon-screenshot"> icon-screenshot</span><br /><br />\r\n      <span class="icon-search"> icon-search</span><br /><br />\r\n      <span class="icon-share"> icon-share</span><br /><br />\r\n      <span class="icon-share-alt"> icon-share-alt</span><br /><br />\r\n      <span class="icon-shopping-cart"> icon-shopping-cart</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-signal"> icon-signal</span><br /><br />\r\n      <span class="icon-signin"> icon-signin</span><br /><br />\r\n      <span class="icon-signout"> icon-signout</span><br /><br />\r\n      <span class="icon-sitemap"> icon-sitemap</span><br /><br />\r\n      <span class="icon-sort"> icon-sort</span><br /><br />\r\n      <span class="icon-sort-down"> icon-sort-down</span><br /><br />\r\n      <span class="icon-sort-up"> icon-sort-up</span><br /><br />\r\n      <span class="icon-star"> icon-star</span><br /><br />\r\n      <span class="icon-star-empty"> icon-star-empty</span><br /><br />\r\n      <span class="icon-star-half"> icon-star-half</span><br /><br />\r\n      <span class="icon-tag"> icon-tag</span><br /><br />\r\n      <span class="icon-tags"> icon-tags</span><br /><br />\r\n      <span class="icon-tasks"> icon-tasks</span><br /><br />\r\n      <span class="icon-thumbs-down"> icon-thumbs-down</span><br /><br />\r\n      <span class="icon-thumbs-up"> icon-thumbs-up</span><br /><br />\r\n      <span class="icon-time"> icon-time</span><br /><br />\r\n      <span class="icon-tint"> icon-tint</span><br /><br />\r\n      <span class="icon-trash"> icon-trash</span><br /><br />\r\n      <span class="icon-trophy"> icon-trophy</span><br /><br />\r\n      <span class="icon-truck"> icon-truck</span><br /><br />\r\n      <span class="icon-umbrella"> icon-umbrella</span><br /><br />\r\n      <span class="icon-upload"> icon-upload</span><br /><br />\r\n      <span class="icon-upload-alt"> icon-upload-alt</span><br /><br />\r\n      <span class="icon-user"> icon-user</span><br /><br />\r\n      <span class="icon-user-md"> icon-user-md</span><br /><br />\r\n      <span class="icon-volume-off"> icon-volume-off</span><br /><br />\r\n      <span class="icon-volume-down"> icon-volume-down</span><br /><br />\r\n      <span class="icon-volume-up"> icon-volume-up</span><br /><br />\r\n      <span class="icon-warning-sign"> icon-warning-sign</span><br /><br />\r\n      <span class="icon-wrench"> icon-wrench</span><br /><br />\r\n      <span class="icon-zoom-in"> icon-zoom-in</span><br /><br />\r\n      <span class="icon-zoom-out"> icon-zoom-out</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Text Editor Icons</h3>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-file"> icon-file</span><br /><br />\r\n      <span class="icon-cut"> icon-cut</span><br /><br />\r\n      <span class="icon-copy"> icon-copy</span><br /><br />\r\n      <span class="icon-paste"> icon-paste</span><br /><br />\r\n      <span class="icon-save"> icon-save</span><br /><br />\r\n      <span class="icon-undo"> icon-undo</span><br /><br />\r\n      <span class="icon-repeat"> icon-repeat</span><br /><br />\r\n      <span class="icon-paper-clip"> icon-paper-clip</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-text-height"> icon-text-height</span><br /><br />\r\n      <span class="icon-text-width"> icon-text-width</span><br /><br />\r\n      <span class="icon-align-left"> icon-align-left</span><br /><br />\r\n      <span class="icon-align-center"> icon-align-center</span><br /><br />\r\n      <span class="icon-align-right"> icon-align-right</span><br /><br />\r\n      <span class="icon-align-justify"> icon-align-justify</span><br /><br />\r\n      <span class="icon-indent-left"> icon-indent-left</span><br /><br />\r\n      <span class="icon-indent-right"> icon-indent-right</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-font"> icon-font</span><br /><br />\r\n      <span class="icon-bold"> icon-bold</span><br /><br />\r\n      <span class="icon-italic"> icon-italic</span><br /><br />\r\n      <span class="icon-strikethrough"> icon-strikethrough</span><br /><br />\r\n      <span class="icon-underline"> icon-underline</span><br /><br />\r\n      <span class="icon-link"> icon-link</span><br /><br />\r\n      <span class="icon-columns"> icon-columns</span><br /><br />\r\n      <span class="icon-table"> icon-table</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-th-large"> icon-th-large</span><br /><br />\r\n      <span class="icon-th"> icon-th</span><br /><br />\r\n      <span class="icon-th-list"> icon-th-list</span><br /><br />\r\n      <span class="icon-list"> icon-list</span><br /><br />\r\n      <span class="icon-list-ol"> icon-list-ol</span><br /><br />\r\n      <span class="icon-list-ul"> icon-list-ul</span><br /><br />\r\n      <span class="icon-list-alt"> icon-list-alt</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Directional Icons</h3>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-arrow-down"> icon-arrow-down</span><br /><br />\r\n      <span class="icon-arrow-left"> icon-arrow-left</span><br /><br />\r\n      <span class="icon-arrow-right"> icon-arrow-right</span><br /><br />\r\n      <span class="icon-arrow-up"> icon-arrow-up</span><br /><br />\r\n      <span class="icon-chevron-down"> icon-chevron-down</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-circle-arrow-down"> icon-circle-arrow-down</span><br /><br />\r\n      <span class="icon-circle-arrow-left"> icon-circle-arrow-left</span><br /><br />\r\n      <span class="icon-circle-arrow-right"> icon-circle-arrow-right</span><br /><br />\r\n      <span class="icon-circle-arrow-up"> icon-circle-arrow-up</span><br /><br />\r\n      <span class="icon-chevron-left"> icon-chevron-left</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-caret-down"> icon-caret-down</span><br /><br />\r\n      <span class="icon-caret-left"> icon-caret-left</span><br /><br />\r\n      <span class="icon-caret-right"> icon-caret-right</span><br /><br />\r\n      <span class="icon-caret-up"> icon-caret-up</span><br /><br />\r\n      <span class="icon-chevron-right"> icon-chevron-right</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-hand-down"> icon-hand-down</span><br /><br />\r\n      <span class="icon-hand-left"> icon-hand-left</span><br /><br />\r\n      <span class="icon-hand-right"> icon-hand-right</span><br /><br />\r\n      <span class="icon-hand-up"> icon-hand-up</span><br /><br />\r\n      <span class="icon-chevron-up"> icon-chevron-up</span><br /><br />\r\n    </div>\r\n  </div>\r\n<div class="clear"></div>\r\n  <div>\r\n    <h3>Video Player Icons</h3>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-play-circle"> icon-play-circle</span><br /><br />\r\n      <span class="icon-play"> icon-play</span><br /><br />\r\n      <span class="icon-pause"> icon-pause</span><br /><br />\r\n      <span class="icon-stop"> icon-stop</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-step-backward"> icon-step-backward</span><br /><br />\r\n      <span class="icon-fast-backward"> icon-fast-backward</span><br /><br />\r\n      <span class="icon-backward"> icon-backward</span><br /><br />\r\n      <span class="icon-forward"> icon-forward</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-fast-forward"> icon-fast-forward</span><br /><br />\r\n      <span class="icon-step-forward"> icon-step-forward</span><br /><br />\r\n      <span class="icon-eject"> icon-eject</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-fullscreen"> icon-fullscreen</span><br /><br />\r\n      <span class="icon-resize-full"> icon-resize-full</span><br /><br />\r\n      <span class="icon-resize-small"> icon-resize-small</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Social Icons</h3>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-phone"> icon-phone</span><br /><br />\r\n      <span class="icon-phone-sign"> icon-phone-sign</span><br /><br />\r\n      <span class="icon-facebook"> icon-facebook</span><br /><br />\r\n      <span class="icon-facebook-sign"> icon-facebook-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-twitter"> icon-twitter</span><br /><br />\r\n      <span class="icon-twitter-sign"> icon-twitter-sign</span><br /><br />\r\n      <span class="icon-github"> icon-github</span><br /><br />\r\n      <span class="icon-github-sign"> icon-github-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-linkedin"> icon-linkedin</span><br /><br />\r\n      <span class="icon-linkedin-sign"> icon-linkedin-sign</span><br /><br />\r\n      <span class="icon-pinterest"> icon-pinterest</span><br /><br />\r\n      <span class="icon-pinterest-sign"> icon-pinterest-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <span class="icon-google-plus"> icon-google-plus</span><br /><br />\r\n      <span class="icon-google-plus-sign"> icon-google-plus-sign</span><br /><br />\r\n      <span class="icon-sign-blank"> icon-sign-blank</span><br /><br />\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-demo-space">\r\n  <h2>&lt;ul&gt; List Styles (Icons)</h2>\r\n\r\n  <p>To replicate, use the following format: <strong>&lt;ul class="list-icon icon_name"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt; (HTML)</strong> or <strong>&#91;list class="list-icon icon_name"&#93;&#91;li&#93;....&#91;/li&#93;&#91;li....&#91;/li&#93;&#91;/list&#93; (ROKCANDY)</strong>. The icon names are listed below, such as "<strong>cart</strong>".</p>\r\n\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="list-icon email">\r\n        <li>A list item using the <strong>list-icon email</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon email</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon phone">\r\n        <li>A list item using the <strong>list-icon phone</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon phone</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon quote">\r\n        <li>A list item using the <strong>list-icon quote</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon quote</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon twitter">\r\n        <li>A list item using the <strong>list-icon twitter</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon twitter</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon youtube">\r\n        <li>A list item using the <strong>list-icon youtube</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon youtube</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon facebook">\r\n        <li>A list item using the <strong>list-icon facebook</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon facebook</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon cart nomarginbottom">\r\n        <li>A list item using the <strong>list-icon cart</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon cart</strong> class.</li>  </ul>\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="list-icon tags">\r\n        <li>A list item using the <strong>list-icon tags</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon tags</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon write">\r\n        <li>A list item using the <strong>list-icon write</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon write</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon info">\r\n        <li>A list item using the <strong>list-icon info</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon info</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon sound">\r\n        <li>A list item using the <strong>list-icon sound</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon sound</strong> class.</li>  </ul>\r\n      <br />\r\n      <ul class="list-icon rightarrow">\r\n        <li>A list item using the <strong>list-icon rightarrow</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon rightarrow</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon skype">\r\n        <li>A list item using the <strong>list-icon skype</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon skype</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon rss nomarginbottom">\r\n        <li>A list item using the <strong>list-icon rss</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon rss</strong> class.</li>\r\n      </ul>\r\n    </div>  \r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="list-icon leftarrow">\r\n        <li>A list item using the <strong>list-icon leftarrow</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon leftarrow</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon circlearrow">\r\n        <li>A list item using the <strong>list-icon circlearrow</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon circlearrow</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon dropbox">\r\n        <li>A list item using the <strong>list-icon dropbox</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon dropbox</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon vimeo">\r\n        <li>A list item using the <strong>list-icon vimeo</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon vimeo</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon downarrow">\r\n        <li>A list item using the <strong>list-icon downarrow</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon downarrow</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon video">\r\n        <li>A list item using the <strong>list-icon video</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon video</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon like nomarginbottom">\r\n        <li>A list item using the <strong>list-icon like</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon like</strong> class.</li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="list-icon uparrow">\r\n        <li>A list item using the <strong>list-icon uparrow</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon uparrow</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon person">\r\n        <li>A list item using the <strong>list-icon person</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon person</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon calendar">\r\n        <li>A list item using the <strong>list-icon calendar</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon calendar</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon bulb">\r\n        <li>A list item using the <strong>list-icon bulb</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon bulb</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon paypal">\r\n        <li>A list item using the <strong>list-icon paypal</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon paypal</strong> class.</li>\r\n      </ul>\r\n      <br />\r\n      <ul class="list-icon doc nomarginbottom">\r\n        <li>A list item using the <strong>list-icon doc</strong> class.</li>\r\n        <li>A list item using the <strong>list-icon doc</strong> class.</li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n<div class="rt-demo-space">\r\n  <h2>&lt;ul&gt; List Styles (CSS3)</h2>\r\n\r\n  <p>These list styles are based on the latest CSS3 techniques and are designed to work in modern browsers (will not display properly in IE6-IE8).</p>\r\n\r\n  <p>To replicate, use the following format: <strong>&lt;ul class="class name"&gt;&lt;li&gt;....&lt;/li&gt;&lt;li&gt;....&lt;/li&gt;...&lt;/ul&gt; (HTML)</strong> or <strong>&#91;list class=&quot;class name&quot;&#93;&#91;li&#93;....&#91;/li&#93;&#91;li....&#91;/li&#93;&#91;/list&#93; (ROKCANDY)</strong>. The class names are listed below, such as "<strong>checkmark red</strong>".</p>\r\n\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="checkmark">\r\n        <li>checkmark</li>\r\n        <li>checkmark</li>\r\n      </ul>\r\n      \r\n      <ul class="circle-checkmark">\r\n        <li>circle-checkmark</li>\r\n        <li>circle-checkmark</li>\r\n      </ul>\r\n      \r\n      <ul class="square-checkmark">\r\n        <li>square-checkmark</li>\r\n        <li>square-checkmark</li>\r\n      </ul>\r\n      \r\n      <ul class="checkmark green">\r\n        <li>checkmark green</li>\r\n        <li>checkmark green</li>\r\n      </ul>\r\n      \r\n      <ul class="checkmark yellow">\r\n        <li>checkmark yellow</li>\r\n        <li>checkmark yellow</li>\r\n      </ul>\r\n      \r\n      <ul class="checkmark red nomarginbottom">\r\n        <li>checkmark red</li>\r\n        <li>checkmark red</li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="checkmark blue">\r\n        <li>checkmark blue</li>\r\n        <li>checkmark blue</li>\r\n      </ul>\r\n      \r\n      <ul class="checkmark white">\r\n        <li>checkmark white</li>\r\n        <li>checkmark white</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle-small">\r\n        <li>triangle-small</li>\r\n        <li>triangle-small</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle">\r\n        <li>triangle</li>\r\n        <li>triangle</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle-large">\r\n        <li>triangle-large</li>\r\n        <li>triangle-large</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle green nomarginbottom">\r\n        <li>triangle green</li>\r\n        <li>triangle green</li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="triangle yellow">\r\n        <li>triangle yellow</li>\r\n        <li>triangle yellow</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle red">\r\n        <li>triangle red</li>\r\n        <li>triangle red</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle blue">\r\n        <li>triangle blue</li>\r\n        <li>triangle blue</li>\r\n      </ul>\r\n      \r\n      <ul class="triangle white">\r\n        <li>triangle white</li>\r\n        <li>triangle white</li>\r\n      </ul>\r\n      \r\n      <ul class="circle-small">\r\n        <li>circle-small</li>\r\n        <li>circle-small</li>\r\n      </ul>\r\n      \r\n      <ul class="circle nomarginbottom">\r\n        <li>circle</li>\r\n        <li>circle</li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n  <div class="rt-demo-width-25">\r\n    <div class="rt-demo-space">\r\n      <ul class="circle-large">\r\n        <li>circle-large</li>\r\n        <li>circle-large</li>\r\n      </ul>\r\n      \r\n      <ul class="circle green">\r\n        <li>circle green</li>\r\n        <li>circle green</li>\r\n      </ul>\r\n      \r\n      <ul class="circle yellow">\r\n        <li>circle yellow</li>\r\n        <li>circle yellow</li>\r\n      </ul>\r\n      \r\n      <ul class="circle red">\r\n        <li>circle red</li>\r\n        <li>circle red</li>\r\n      </ul>\r\n      \r\n      <ul class="circle blue">\r\n        <li>circle blue</li>\r\n        <li>circle blue</li>\r\n      </ul>\r\n      \r\n      <ul class="circle white nomarginbottom">\r\n        <li>circle white</li>\r\n        <li>circle white</li>\r\n      </ul>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-demo-space">\r\n  <h2>&lt;span&gt; Inset Styles</h2>\r\n\r\n  <p>\r\n    Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.\r\n    <span class="inset-right nomarginbottom"><span class="inset-right-title">Inset Right Title</span>You will need to use the following formatting: <strong>&lt;span class=&quot;inset-right&quot;&gt; &lt;span class=&quot;inset-right-title&quot;&gt; .... &lt;/span&gt; <em class="normal"> ... some content ... </em>&lt;/strong&gt; (HTML)</strong> or <strong>&#91;inset side="right" title="Inset Right Title"&#93; ... some content ...&#91;/inset&#93; (ROKCANDY)</strong></span>\r\n    Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed euismod magna a nibh.\r\n  </p>\r\n\r\n  <p>\r\n    Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.\r\n    <span class="inset-left nomarginbottom"><span class="inset-left-title">Inset Left Title</span>You will need to use the following formatting: <strong>&lt;span class=&quot;inset-left&quot;&gt; &lt;span class=&quot;inset-left-title&quot;&gt; .... &lt;/span&gt; <em class="normal"> ... some content ... </em>&lt;/strong&gt; (HTML)</strong> or <strong>&#91;inset side="left" title="Inset Left Title"&#93; ... some content ...&#91;/inset&#93; (ROKCANDY)</strong></span>\r\n    Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed euismod magna a nibh.</p>\r\n\r\n  <p>Sed euismod magna a nibh. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque.</p>\r\n  <p class="nomarginbottom">Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.Praesent rutrum sapien ac felis. Phasellus elementum dolor quis turpis. Vestibulum nec mi vitae pede tincidunt nonummy. Vestibulum facilisis mollis neque. Sed orci. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.\r\n  </p>\r\n</div>\r\n\r\n<div class="clear"></div>', '', 1, 11, '2012-08-09 11:31:53', 402, '', '2012-09-04 10:53:09', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:31:53', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 7, '', '', 1, 76, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(5, 49, 'Menu Options', 'menu-options', '<p class="alert">RokNavMenu is the core of all the powerful Fracture menu system. Please ensure you are using the latest version of RokNavMenu, available <a href="http://www.rockettheme.com/extensions-joomla/roknavmenu" target="_blank">here</a>.</p>\r\n\r\n<h2>Fusion with MegaMenu</h2>\r\n\r\n<p><strong>Fusion Menu</strong> is a menu theme of the <strong>RokNavMenu</strong> extension, the addon that drives all RocketTheme template menus. It is primarily a javascript enhanced CSS dropdown menu, that combines standard suckerfish type functionality with animations, transitions and other advanced effects powered by Mootools.</p>\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/menu-options/fusionmenu.jpg" alt="FusionMenu" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<h2>SplitMenu</h2>\r\n\r\n<p>A static menu system that displays 1st level items in the main horizontal menu and further children in the Sidebar.</p>\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/menu-options/splitmenu.jpg" alt="SplitMenu" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<p class="notice">All Menu Items can be edited from <strong>Admin &rarr; Menu &rarr; <em>Menu Name</em> &rarr; <em>Menu Item</em></strong>.</p>\r\n\r\n<br />\r\n\r\n<h2>Creating child menu items</h2>\r\n\r\n<p>Go to <strong>Admin &rarr; Menu &rarr; <em>A Menu</em> &rarr; <em>A Menu Item</em> &rarr; Select a <em>Parent Item</em></strong>, and it will appear as a child of it.</p>\r\n\r\n<div class="rt-demo-block rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/menu-options/childmenu-1.jpg" alt="image" />\r\n    </div> \r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-block rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/menu-options/childmenu-2.jpg" alt="image" />\r\n    </div>  \r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n', '', 1, 11, '2012-08-09 11:32:05', 402, '', '2012-09-02 17:30:50', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:32:05', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 6, '', '', 1, 129, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(6, 50, 'Integrated Extensions', 'integrated-extensions', '<div class="rt-center largemargintop largemarginbottom">\r\n  <span class="promo2">Integrated Extensions</span><br />\r\n  <span class="promo3">Enhance Your Website with the <strong>Powerful Tools</strong></span>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<div class="rt-center">\r\n<a target="_blank" href="http://www.rockettheme.com/joomla-templates/fracture" class="readon medmargintop"><span><span class="icon-download-alt"></span>Download</span></a>\r\n</div>', '', 1, 11, '2012-08-09 11:32:16', 402, '', '2012-09-02 19:15:24', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:32:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 5, '', '', 1, 93, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(7, 51, 'Tutorials and Guides', 'tutorials-and-guides', '<p>Fracture for Joomla is a RocketTheme Joomla Template Club release featuring the revolutionary Gantry Joomla Template Framework. Gantry is a comprehensive set of building blocks to enable the rapid development and realization of a design into a flexible and powerful web platform theme.</p>\r\n\r\n<p class="notice">To configure the template, navigate to <strong>Extensions &rarr; Template Manager &rarr; <em>rt_fracture</em></strong>. Mouseover the labels to view a description of each parameter.</p>', '', 1, 11, '2012-08-09 11:32:31', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:32:31', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 4, '', '', 1, 95, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(8, 52, 'Installation Instructions', 'installation-instructions', '<p>The following is a guide that covers how to set up your new <strong>Fracture</strong> template on your Joomla! site. Here you can find an overview of the files included in the Fracture release and instructions on installing and activating the template in your Joomla! install.</p>\r\n\r\n<p class="notice nomarginbottom"><strong>Note:</strong> The <strong>Bundle</strong> Template is only necessary if the Gantry Library is not installed at <strong>/libraries/gantry directory</strong>.</p>\r\n\r\n<br />\r\n\r\n<h3>Step 1 - Installation</h3>\r\n\r\n<ol class="largemarginbottom">\r\n  <li>Install from <strong>Admin &rarr; Extensions &rarr; Extensions Manager</strong></li>\r\n  <li>Browse for <strong>rt_fracture.zip</strong> and click <strong>Upload &amp; Install</strong></li>  \r\n</ol>\r\n\r\n<div class="rt-image">\r\n  <img alt="Image" src="images/rocketlauncher/installation/installation-1.jpg" />\r\n</div>\r\n\r\n<div class="clear">&nbsp;</div>\r\n\r\n<br />\r\n\r\n<h3>Step 2 - Template Default</h3>\r\n\r\n<ol class="largemarginbottom">\r\n  <li>Make the template default at <strong>Admin &rarr; Extensions &rarr; Template Manager</strong></li>\r\n  <li>Select <strong>rt_fracture</strong></li>\r\n  <li>Press <strong>Make Default</strong></li>\r\n</ol>\r\n\r\n<div class="rt-image">\r\n  <img alt="Image" src="images/rocketlauncher/installation/installation-2.jpg" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<h2>RocketLauncher Instructions</h2>\r\n\r\n<p class="nomarginbottom">We always recommend installing a <strong>RocketLauncher</strong> first to trial and understand the template more effectively. It must be installed as <strong>new</strong>, and <strong>not</strong> over an existing Joomla install.</p>\r\n\r\n<br />\r\n\r\n<h3>Step 1 - Upload</h3>\r\n\r\n<ul class="medmarginbottom">\r\n  <li><strong>Download</strong> the RocketLauncher</li>\r\n  <li><strong>Unzip</strong> the file</li>\r\n  <li><strong>Upload</strong> the created folder to your server</li>\r\n</ul>\r\n\r\n<p class="notice nomarginbottom"><strong>Note:</strong> You can upload all the files via FTP, or use cPanel or SSH to upload the zip and unzip directly onto the server. Enquire with your hosting provider.</p>\r\n\r\n<br />\r\n\r\n<h3>Step 2 - Installation</h3>\r\n\r\n<ul>\r\n  <li>Go to <a href="#">www.yoursite.com/<em>*folder name*</em></a></li>\r\n  <li>Follow the Installation instructions</li>\r\n  <li>Ensure you click <em class="bold2">Install Sample Data</em> during installation</li>\r\n  <li>Remove the installation folder in the Installation interface</li>\r\n</ul>\r\n', '', 1, 11, '2012-08-09 11:33:29', 402, '', '2012-09-02 13:49:20', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:33:29', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 3, '', '', 1, 84, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(9, 53, 'Logo Editing', 'logo-editing', '<p>There are two methods of changing the Fracture logo: <strong>via the logo picker</strong> and <strong>manual</strong> change.</p>\r\n\r\n<h3>The Logo Picker</h3>\r\n\r\n<ol>\r\n  <li>Enable <strong>Logo</strong> and set to <strong>Custom</strong> at <em>Admin &rarr; Extensions &rarr; Templates Manager &rarr; rt_fracture &rarr; Features.</em></li>\r\n  <li>Set <strong>Logo Picker</strong> to either <strong>RokGallery</strong> or <strong>MediaManager</strong>.</li>\r\n  <li><strong>Select</strong> your logo, <strong>Insert</strong> and <strong>Save</strong></li>\r\n</ol>\r\n\r\n<br />\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/logo-editing/logo-panel.jpg" alt="Logo Panel" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/logo-editing/select-logo.jpg" alt="Select Logo" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div><br />\r\n\r\n<h3>Manual Change</h3>\r\n\r\n<ol>\r\n  <li>Enable <strong>Logo</strong> and set <strong>Type</strong> to <strong>Fracture</strong>.</li>\r\n  <li>Upload <strong>logo.png</strong> to the <br /><strong> /templates/rt_fracture/images/logo/*style*</strong> directory</li>\r\n  <li>Clear your browser cache and refresh.</li>\r\n</ol>\r\n\r\n<div class="clear"></div><br />\r\n\r\n<p>If you cannot see your new logo, ensure you have uploaded it to the right directory and the directory permissions are writeable. Enquire with your hosting provider.</p>\r\n\r\n<a target="_blank" href="http://www.rockettheme.com/joomla-templates/fracture" class="readon"><span>Download Sources Here</span></a>\r\n\r\n<div class="clear"></div>\r\n', '', 1, 11, '2012-08-09 11:33:40', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:33:40', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 2, '', '', 1, 56, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(10, 54, 'Preset Styles', 'preset-styles', '<p>The <strong>Style Settings</strong> panel in the Gantry based theme administration interface provides several options for configuring the main built in stylistic aspects of the template.</p>\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/styles/admin-style-panel.jpg" alt="Style" />\r\n</div>\r\n\r\n<br />\r\n\r\n<p>Gantry also provides the ability for you to create your own custom presets based on any parameter in the theme administrator. You should determine which parameters you wish to configure to be a part of the presets.</p>\r\n\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n<h2>Assigning a Style</h2>\r\n\r\n<p>With Gantry, the ability to assign a certain style to an individual page has never been easier and/or more efficient. Just follow these simple steps:</p>\r\n\r\n<ul>\r\n  <li>Go to <strong>Extensions → Template Manager → rt_fracture &rarr; Assignments &rarr; <em>*Menu Item*</em></strong></li>  \r\n  <li>Select your preset from <strong>Show Presets</strong>, configure and save.</li>\r\n</ul>\r\n\r\n<br />\r\n\r\n<p>After setting your defaults to the desired values, select the Menu Items button and choose the menu item you wish to modify the parameters for. You will then see a series of checkboxes on the left of all the supported parameters.</p>\r\n\r\n<p>Select the checkbox next to the parameter you wish to modify, it will then become active, and you can modify as you wish. Clicking “<strong>Save</strong>” in the toolbar will then save this configuration.</p>\r\n\r\n<a href="http://gantry-framework.org/documentation/joomla/configure/style" class="readon largemargintop"><span>Gantry Framework: Style Configuration</span></a>\r\n', '', 1, 11, '2012-08-09 11:34:36', 402, '', '2012-09-02 13:28:07', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:34:36', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 1, '', '', 1, 376, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(11, 55, 'About Joomla!', 'about-joomla', '<h3>What is Joomla?</h3>\r\n<p>Joomla is an award-winning content management system (CMS), which enables you to build Web sites and powerful online applications. Many aspects, including its ease-of-use and extensibility, have made Joomla the most popular Web site software available. Best of all, Joomla is an open source solution that is freely available to everyone.</p>\r\n\r\n<p>With millions of websites running on Joomla, the software is used by individuals, small &amp; medium-sized businesses, and large organizations worldwide to easily create &amp; build a variety of websites &amp; web-enabled applications.</p>\r\n\r\n<h3>What Joomla! can do?</h3>\r\n<p>Joomla is used all over the world to power Web sites of all shapes and sizes. For example:</p>\r\n<ul>\r\n  <li>Corporate Web sites or portals</li>\r\n  <li>Corporate intranets and extranets</li>\r\n  <li>Online magazines, newspapers, and publications</li>\r\n  <li>E-commerce and online reservations</li>\r\n  <li>Government applications</li>\r\n  <li>Small business Web sites</li>\r\n  <li>Non-profit and organizational Web sites</li>\r\n  <li>Community-based portals</li>\r\n  <li>School and church Web sites</li>\r\n  <li>Personal or family homepages</li>\r\n</ul>\r\n\r\n<br />\r\n\r\n<h3>Site and Administrator</h3>\r\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the "Site Administrator" link on the "This Site" menu or by adding /administrator to the end of you domain name.</p>\r\n<p>Log in to the administrator using the username and password created during the installation of Joomla.</p>\r\n\r\n<h3>Learn More</h3>\r\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href="http://docs.joomla.org" target="_blank">Joomla! documentation site</a> and on the<a href="http://forum.joomla.org" target="_blank"> Joomla! forums</a>.</p>\r\n\r\n<a href="http://www.joomla.org/" target="_blank" class="readon"><span>Visit Joomla!</span></a>', '', 1, 11, '2012-08-09 11:34:49', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:34:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 88, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(12, 56, 'Donec Nunc Magna Posuere', 'donec-nunc-magna-posuere', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:36:23', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:36:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(13, 57, 'Lorem Ipsum Dolor Sit Amet', 'lorem-ipsum-dolor-sit-amet', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:36:35', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:36:35', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(14, 58, 'Vestibulum Dapibus Est Nulla', 'vestibulum-dapibus-est-nulla', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:37:49', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:37:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(15, 59, 'Nec Libero Laoreet Faucibus', 'nec-libero-laoreet-faucibus', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:38:00', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:38:00', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(16, 60, 'Sed Imperdiet Ligula Nisi', 'sed-imperdiet-ligula-nisi', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:38:16', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:38:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(17, 61, 'Massa Diam Tristique Urna', 'massa-diam-tristique-urna', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:39:15', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:39:15', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(18, 62, 'Sapien Eros Consetur Dolor', 'sapien-eros-consetur-dolor', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:39:33', 402, '', '2012-09-02 13:21:37', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:39:33', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(19, 63, 'Maecenas Varius Neque Nec', 'maecenas-varius-neque-nec', '<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Etiam dapibus, tellus ac ornare aliquam, massa diam tristique urna, id faucibus lectus erat ut pede.</p>\r\n\r\n<p>Maecenas varius neque nec libero laoreet faucibus. Phasellus sodales, lectus sed vulputate rutrum, ipsum nulla lacinia magna, sed imperdiet ligula nisi eu ipsum. Donec nunc magna, posuere eget, aliquam in, vulputate in, lacus.</p>\r\n\r\n', '\r\n\r\n<p>In erat. Pellentesque erat. Mauris vehicula vestibulum justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla pulvinar est. Integer urna. Pellentesque pulvinar dui a magna. Nulla facilisi.</p>\r\n\r\n<p>Proin imperdiet. Aliquam ornare, metus vitae gravida dignissim, nisi nisl ultricies felis, ac tristique enim pede eget elit. Integer non erat nec turpis sollicitudin malesuada. Vestibulum dapibus. Nulla facilisi. Nulla iaculis, leo sit amet mollis luctus, sapien eros consecetur dolor, eu faucibus elit nibh eu nibh. Maecenas lacus pede, lobortis non, rhoncus id, tristique a, mi. Cras auctor libero vitae sem vestibulum euismod. Nunc fermentum.</p>', 1, 12, '2012-08-09 11:39:45', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:39:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(20, 64, 'Flexible Layouts.', 'flexible-layouts', '<p>Fracture has a responsive layout, meaning it adapts to the widths of the viewing device, as powered by the responsive Gantry 4 Framework.</p>', '', 1, 13, '2012-08-09 11:43:54', 402, '', '2012-08-30 15:28:12', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:43:54', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 15, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(21, 65, 'Core Framework.', 'core-framework', '<p>The Gantry Framework sits at the core of the template, providing the base for the major features and functions, such as the responsive grid.</p>', '', 1, 13, '2012-08-09 11:44:49', 402, '', '2012-08-09 11:53:13', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:44:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 14, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(22, 66, 'Website Speed.', 'site-performance', '<p>Increase the speed of your site by enabling the RokBooster plug-in which will compress and combine your CSS &amp; JavaScript into as few files as possible</p>', '', 1, 13, '2012-08-09 11:45:13', 402, '', '2012-09-02 19:38:50', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:45:13', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 13, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(23, 67, 'Preset Styles.', 'preset-styles', '<p>Fracture has 10 stunning preset style variations to choose from, as well as configure from the Gantry administrator, in addition to custom module variations.</p>', '', 1, 13, '2012-08-09 11:46:16', 402, '', '2012-08-30 15:31:22', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:46:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 12, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(24, 68, 'Powerful Menu.', 'powerful-menu', '<p>There are two menu options available: Fusion, the Mootools enhanced CSS dropdown menu, and SplitMenu, a static menu.</p>', '', 1, 13, '2012-08-09 11:47:39', 402, '', '2012-08-30 15:35:41', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:47:39', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 11, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(25, 69, 'K2 Styling.', 'k2-styling', '<p>Fracture has styled, including responsive, support for the popular third party content / CCK extension by JoomlaWorks.gr, K2.</p>', '', 1, 13, '2012-08-09 11:47:59', 402, '', '2012-08-09 12:00:32', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:47:59', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 10, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(26, 70, '84 Positions.', '84-positions', '<p>A vast module positions assortment, spread over Gantry Grid Rows, split into groupings of six, for maximum flexibility</p>', '', 1, 13, '2012-08-09 11:48:14', 402, '', '2012-09-02 19:12:24', 410, 0, '0000-00-00 00:00:00', '2012-08-09 11:48:14', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 9, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(27, 71, 'Logo Picker.', 'logo-picker', '<p>There are two methods of changing the Fracture logo, via the logo picker or by manual change. Choose the logo from RokGallery or Media Manager.</p>', '', 1, 13, '2012-08-09 11:48:51', 402, '', '2012-08-09 11:49:28', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:48:51', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(28, 72, 'RokSprocket.', 'roksprocket', '<p>A powerful switchblade content extension, that provides an array of display options, all within one single modular framework with an intuitive interface</p>', '', 1, 13, '2012-08-09 11:49:08', 402, '', '2012-08-09 11:49:34', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:49:08', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(29, 73, 'Tutorials.', 'tutorials', '<p>Extensive overview of template files and instructions for installing and activating the template and overview for customizing the template logo</p>', '', 1, 13, '2012-08-09 11:51:14', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:51:14', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(30, 74, 'Module Variants.', 'module-variants', '<p>Fracture has a range of module class suffixes, both stylistic and structural that allow you to individualize a module to create unique layouts &amp; appearances</p>', '', 1, 13, '2012-08-09 11:51:34', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:51:34', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(31, 75, 'RokGallery.', 'rokgallery', '<p>RokGallery is an advanced gallery extension, resting on a custom tag based architecture, with an non-destructive slice editor to edit photos easily</p>', '', 1, 13, '2012-08-09 11:51:54', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:51:54', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(32, 76, 'Mosaic Layout.', 'mosaic-layout', '<p>Mosaic, a template layout for RokSprocket, presents content in a dynamic and interactive grid structure; perfect for magazine and content sites</p>', '', 1, 13, '2012-08-09 11:52:42', 402, '', '2012-08-09 11:55:00', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:52:42', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(33, 77, 'FusionMenu.', 'fusionmenu', '<p>Fusion with MegaMenu is a Mootools enhanced, CSS dropdown menu system, with features such as multiple columns and inline icons.</p>', '', 1, 13, '2012-08-09 11:56:08', 402, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-08-09 11:56:08', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(34, 78, 'SplitMenu.', 'splitmenu', '<p>SplitMenu is a basic, static menu system that places parent items in the header navigation area, and all children in the sidebar, or as configured.</p>', '', 1, 13, '2012-08-09 11:57:48', 402, '', '2012-08-09 12:00:11', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:57:48', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(35, 79, 'Integrated Extensions.', 'integrated-extensions', '<p>Fracture has styled, including responsive, support for the popular third party content / CCK extension by JoomlaWorks.gr, K2.</p>', '', 1, 13, '2012-08-09 11:59:00', 402, '', '2012-08-09 12:01:01', 977, 0, '0000-00-00 00:00:00', '2012-08-09 11:59:00', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_tag` (`tag_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `table` varchar(255) NOT NULL DEFAULT '',
  `rules` text NOT NULL,
  `field_mappings` text NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) NOT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}], "special": [{"fulltext":"fulltext"}]}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}], "special": []}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}], "special": [{"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}]}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}], "special": [{"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}]}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}], "special": [{}]}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}]}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(11, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(12, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(13, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(14, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(15, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":""}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"Unknown","author":"Joomla! Project","copyright":"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":""}', '{"show_contact_category":"hide","show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","allow_vcard_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_category_crumb":"0","metakey":"","metadesc":"","robots":"","author":"","rights":"","xreference":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":""}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0","show_headings":"1","show_name":"1","show_articles":"0","show_link":"1","show_description":"1","show_description_image":"1","display_num":"","show_pagination_limit":"1","show_pagination":"1","show_pagination_results":"1","show_cat_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":""}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"0","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{"name":"com_weblinks","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":""}', '{"target":"0","count_clicks":"1","icons":2,"link_icons":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_num_links":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_links_cat":"1","show_pagination_limit":"1","show_headings":"0","show_link_description":"1","show_link_hits":"1","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":""}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","show_category":"0","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_author":"1","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"1","show_item_navigation":"0","show_vote":"0","show_readmore":"1","show_readmore_title":"1","readmore_limit":"100","show_icons":"1","show_print_icon":"1","show_email_icon":"1","show_hits":"0","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","show_urls_images_frontend":"0","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"left","float_fulltext":"left","category_layout":"_:blog","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"0","num_intro_articles":"4","num_columns":"1","num_links":"4","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"2":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":""}', '{"allowUserRegistration":"1","new_usertype":"2","useractivation":"1","frontend_userparams":"1","mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":""}', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stemmer":"snowball"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{"updatesource":"sts","customurl":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, '{"name":"PHPMailer","type":"library","creationDate":"2001","author":"PHPMailer","copyright":"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2013, Jim Jagielski. All Rights Reserved.","authorEmail":"jimjag@gmail.com","authorUrl":"https:\\/\\/github.com\\/PHPMailer\\/PHPMailer","version":"5.2.6","description":"LIB_PHPMAILER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{"name":"SimplePie","type":"library","creationDate":"2004","author":"SimplePie","copyright":"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon","authorEmail":"","authorUrl":"http:\\/\\/simplepie.org\\/","version":"1.2","description":"LIB_SIMPLEPIE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 'phputf8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"phputf8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 'Joomla! Platform', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"Joomla! Platform","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":""}', '{"mediaversion":"4f9b327fe7d577957484e8614afcbe9d"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2013-10-22","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2013 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.1.rc4","description":"LIB_FOF_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters.\\n\\t\\tAll rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":""}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":""}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":""}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":""}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":""}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":""}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(404, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":""}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, 'false', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":""}', '{"style":"xhtml"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":""}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":""}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"3.15","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":""}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"August 2004","author":"Unknown","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2013","author":"Moxiecode Systems AB","copyright":"Moxiecode Systems AB","authorEmail":"N\\/A","authorUrl":"tinymce.moxiecode.com","version":"4.0.10","description":"PLG_TINY_XML_DESCRIPTION","group":""}', '{"mode":"1","skin":"0","entity_encoding":"raw","lang_mode":"0","lang_code":"en","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","toolbar":"top","toolbar_align":"left","html_height":"550","html_width":"750","resizing":"true","resize_horizontal":"false","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","format_date":"%Y-%m-%d","inserttime":"1","format_time":"%H:%M:%S","colors":"1","table":"1","smilies":"1","media":"1","hr":"1","directionality":"1","fullscreen":"1","style":"1","layer":"1","xhtmlxtras":"1","visualchars":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advimage":"1","advlink":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(422, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":""}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":""}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":""}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":""}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2009 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":""}', '{"autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":""}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 1, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":""}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_weblinks","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_WEBLINKS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"Se[ptember 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),

(503, 'beez_20', 'template', 'beez_20', '', 0, 1, 1, 0, 'false', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"hathor@tarrconsulting.com","authorUrl":"http:\\/\\/www.tarrconsulting.com","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":""}', '{"showSiteName":"0","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 'English (United Kingdom)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (United Kingdom)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 'English (United Kingdom)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (United Kingdom)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"November 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 'Gantry', 'library', 'lib_gantry', '', 0, 1, 1, 0, '{"name":"Gantry","type":"library","creationDate":"November 18, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"4.1.19","description":"Gantry Starting Template for Joomla! v4.1.19","group":""}', '{}', '{"last_update":1346687786}', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 'gantry', 'component', 'com_gantry', '', 0, 1, 0, 0, 'false', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10003, 'System - Gantry', 'plugin', 'gantry', 'system', 0, 1, 1, 0, '{"name":"System - Gantry","type":"plugin","creationDate":"November 18, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"4.1.19","description":"Gantry System Plugin for Joomla","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10004, 'Gantry', 'component', 'com_gantry', '', 1, 1, 1, 0, '{"name":"Gantry","type":"component","creationDate":"November 18, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"4.1.19","description":"Gantry Starting Template for Joomla! v4.1.19","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, -1),
(10005, 'rt_fracture', 'template', 'rt_fracture', '', 0, 1, 1, 0, '{"name":"rt_fracture","type":"template","creationDate":" November 19, 2013","author":"RocketTheme, LLC","copyright":"Copyright 2005-2013 - RocketTheme.com","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"1.8-SNAPSHOT","description":"Fracture","group":""}', '{"master":"true"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 'System - RokExtender', 'plugin', 'rokextender', 'system', 0, 1, 1, 0, '{"name":"System - RokExtender","type":"plugin","creationDate":"October 31, 2012","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2012 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.0","description":"System - Gantry","group":""}', '{"registered":"\\/modules\\/mod_roknavmenu\\/lib\\/RokNavMenuEvents.php"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10008, 'RokNavMenu', 'module', 'mod_roknavmenu', '', 0, 1, 1, 0, '{"name":"RokNavMenu","type":"module","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.7","description":"RocketTheme Customizable Navigation Menu","group":""}', '{"limit_levels":"0","startLevel":"0","endLevel":"0","showAllChildren":"0","filteringspacer2":"","theme":"default","custom_layout":"default.php","custom_formatter":"default.php","cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10010, 'RokAjaxSearch', 'module', 'mod_rokajaxsearch', '', 0, 1, 1, 0, '{"name":"RokAjaxSearch","type":"module","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.1","description":"RokAjaxSearch is an ajaxian searcher that displays the results immediately and allows to choose the\\n        proper one.\\n    ","group":""}', '{"moduleclass_sfx":"","search_page":"index.php?option=com_search&view=search&tmpl=component","adv_search_page":"index.php?option=com_search&view=search","spacer_style_options":"","include_css":"1","theme":"blue","spacer_advanced_search":"","searchphrase":"any","ordering":"newest","limit":"10","perpage":"3","websearch":"0","blogsearch":"0","imagesearch":"0","videosearch":"0","websearch_api":"","show_pagination":"1","safesearch":"MODERATE","image_size":"MEDIUM","show_estimated":"1","spacer_advanced_settings":"","hide_divs":"","include_link":"1","show_description":"1","include_category":"1","show_readmore":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10013, 'Editor - RokPad', 'plugin', 'rokpad', 'editors', 0, 1, 1, 0, '{"name":"Editor - RokPad","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.6","description":"\\n        <div class=\\"rokpad-description\\">\\n        <img src=\\"..\\/plugins\\/editors\\/rokpad\\/assets\\/admin\\/images\\/rokpad.jpg\\" class=\\"img-padding\\" \\/><h1>RokPad<\\/h1>\\n        <h2>The Power of Desktop Text Editor in a Joomla!<\\/h2>\\n        <p>Ever wished you could use a powerful desktop text editor such as Textmate, SublimeText, or UltraEdit directly on a Joomla! web site?  Now with RokPad we provide many features and capabilities that traditionally would only be found in a powerful desktop editor.  RokPad provides advanced functions such as an Ajax saving action, syntax highlighting, configurable themes, multiple cursors and selections, shortcut keys, multiple language support, and many other incredible features.<\\/p>\\n\\n        <h2>Key Features:<\\/h2>\\n        <ul class=\\"features\\">\\n\\t\\t\\t<li>Code Highlighter built on the great ACE Editor<\\/li>\\n\\t        <li>Support for CSS, HTML, JavaScript, JSON, LESS, Markdown, PHP, SQL, Plain Text, Textile, XML and more...<\\/li>\\n\\t        <li>Ajax save and Automatic Save options. You''ll never loose your content again, nor wait until the page has finished reloading after a save!<\\/li>\\n\\t        <li>Save, Undo, Redo, Goto line, Advanced Search and Search &amp; Replace, Full Screen. Settings like Themes, Font Size, Code Folding, Wrap Mode, Invisible Characters, Print Margin, Highlight of selected word<\\/li>\\n\\t        <li>26 Themes to choose from<\\/li>\\n\\t        <li>Resizable Editor by dragging the Statusbar<\\/li>\\n\\t        <li>Keyboard shortcuts<\\/li>\\n\\t        <li>Brackets match<\\/li>\\n\\t        <li>Multiple cursors and selections<\\/li>\\n\\t        <li>Vertical Selection<\\/li>\\n\\t        <li>Ability to insert at multiple locations xtd-buttons shortcodes, all at once.<\\/li>\\n\\t        <li>Shortcodes and Universal Tag Insertion<\\/li>\\n\\t        <li>Drag &amp; Drop of text from external applications such as other Browser Tabs\\/windows or Native Applications (Supported on Firefox, Chrome, IE10 and Safari)<\\/li>\\n\\t        <li>Import local files by Drag &amp; Drop directly from your desktop! (Supported on Firefox, Chrome, IE10 and Safari 6+)<\\/li>\\n\\t        <li>And much more!<\\/li>\\n        <\\/ul>\\n        <\\/div>\\n        ","group":""}', '{"autosave-enabled":"0","autosave-time":"5","theme":"fluidvision","font-size":"12px","fold-style":"markbeginend","use-wrap-mode":"free","selection-style":"1","highlight-active-line":"1","highlight-selected-word":"1","show-invisibles":"0","show-gutter":"1","show-print-margin":"1","fade-fold-widgets":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 'System - RokBooster', 'plugin', 'rokbooster', 'system', 0, 0, 1, 0, '{"name":"System - RokBooster","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"1.1.10","description":"\\n        \\n        <div class=\\"booster-description\\">\\n        <img src=\\"..\\/plugins\\/system\\/rokbooster\\/assets\\/images\\/rokbooster.jpg\\" class=\\"img-padding\\" \\/><h1>RokBooster<\\/h1>\\n        <p>Increase the speed of your site by enabling the RokBooster plug-in.  This advanced extensions will <strong>compress<\\/strong> and <strong>combine<\\/strong> your <strong>CSS<\\/strong> and <strong>JavaScript<\\/strong> into as few files as possible each.  RokBooster can dramatically reduce the number of HTTP calls a browser has to make, and sending those compressed files GZipped means your pages will load faster with less load on your server.<\\/p>\\n\\n        <h2>Key Features:<\\/h2>\\n        <ul class=\\"features\\">\\n            <li>Combine and compress CSS and JavaScript into as few files as possible<\\/li>\\n            <li>GZip compression used to send CSS and JavaScript files<\\/li>\\n            <li>Compress Inline CSS and JavaScript<\\/li>\\n            <li>Customizable cache timeout<\\/li>\\n            <li>Background rendering, so initial file processing won''t slow your users down<\\/li>\\n            <li>Full page scan allows for non-header JavaScript and CSS to be included<\\/li>\\n            <li>Ability to ignore specific CSS and JavaScript files<\\/li>\\n        <\\/ul>\\n        <p class=\\"note\\"><strong>NOTE:<\\/strong> Clearing the Joomla cache will remove the RokBooster compressed cache files causing them to regenerate on the next page hit<\\/p>\\n        <\\/div>\\n        \\n    ","group":""}', '{"cache_time":"60","minify_css":"1","style_sort":"RokBooster_Compressor_Sort_ExternalOnTop","inline_css":"1","imported_css":"1","minify_js":"1","script_sort":"RokBooster_Compressor_Sort_ExternalOnTop","inline_js":"1","ignored_files":"","scan_method":"header","use_background_processing":"1","disable_for_ie":"1"}', '', '', 0, '0000-00-00 00:00:00', 100, 0),
(10017, 'System - RokBox', 'plugin', 'rokbox', 'system', 0, 1, 1, 0, '{"name":"System - RokBox","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.6","description":"\\n        <div class=\\"rokbox-description\\">\\n        <img src=\\"..\\/plugins\\/system\\/rokbox\\/assets\\/admin\\/images\\/rokbox.jpg\\" class=\\"img-padding\\" \\/><h1>RokBox2<\\/h1>\\n        <p>RokBox2 is a fully responsive modal pop-up plug-in for Joomla.  It displays <strong>images<\\/strong>, <strong>videos<\\/strong>, <strong>embedded widgets<\\/strong>, <strong>Ajax content<\\/strong> and <strong>Joomla modules<\\/strong>.<\\/p>\\n\\n        <p>RokBox2 contains a <strong>Content plug-in<\\/strong> and <strong>Button Editor plug-in<\\/strong>. The <strong>Content plug-in<\\/strong> can auto-generate thumbnails of <strong>local images<\\/strong> that can be used as content for your RokBox2 links. All thumbnails generated are <strong>responsive<\\/strong> so that they can easily adapt to any device. The <strong>Button Editor plug-in<\\/strong> allows for easy creation of RokBox2 style snippets with just a few clicks.<\\/p>\\n        <p>RokBox2 also provides backward compatibility for RokBox1 style <code>{rokbox}<\\/code> syntax.<\\/p>\\n\\n        <h2>Key Features:<\\/h2>\\n        <ul class=\\"features\\">\\n            <li>HTML5 and CSS3<\\/li>\\n            <li>Fully Responsive<\\/li>\\n            <li>Auto thumbnails generator<\\/li>\\n            <li>Captions supporting HTML syntax<\\/li>\\n            <li>Ajax Content listener<\\/li>\\n            <li>Multiple media types supported:\\n                <ul class=\\"features\\">\\n                    <li>Images: base64 encoded, jpg, gif, png, bmp, webp<\\/li>\\n                    <li>HTML5 Video and Audio<\\/li>\\n                    <li>TwitPic<\\/li>\\n                    <li>Instagram<\\/li>\\n                    <li>YouTube<\\/li>\\n                    <li>Vimeo<\\/li>\\n                    <li>Telly (ex TwitVid)<\\/li>\\n                    <li>Metacafe<\\/li>\\n                    <li>Dailymotion<\\/li>\\n                    <li>Spotify<\\/li>\\n                    <li>Google Maps<\\/li>\\n                <\\/ul>\\n            <\\/li>\\n            <li>Fit\\/Unfit Screen: If an image is too big it gets shrunk to fit the view-port but you can always click the Fit Screen icon to expand it and scroll.<\\/li>\\n            <li>Albums to group related images<\\/li>\\n            <li>Key Bindings for easy navigation: <code>&larr;<\\/code> (Previous), <code>&rarr;<\\/code> (Next), <code>f<\\/code> Fitscreen\\/Unfitscreen, <code>esc<\\/code> Close<\\/li>\\n        <\\/ul>\\n\\n        <p class=\\"note\\"><strong>NOTE:<\\/strong> RokBox2 consists of 3 plug-ins: <strong>Content<\\/strong>, <strong>System<\\/strong> and <strong>Editor Button<\\/strong>. Make sure to have a look at all three plug-in manager pages to get an idea of what they do.<\\/p>\\n        <\\/div>\\n        ","group":""}', '{"theme":"clean","custom-theme":"sample","custom-legacy":"0","width":"640","height":"460","transition":"Quad.easeOut","duration":"200","chase":"40","effect":"quicksilver","frame-border":"20","content-padding":"0","arrows-height":"35","captions":"1","captionsDelay":"800","scrolling":"0","keyEvents":"1","overlay_background":"#000000","overlay_opacity":"0.85","overlay_duration":"200","overlay_transition":"Quad.easeInOut","autoplay":"true","ytautoplay":"0","ythighquality":"0","controller":"false","bgcolor":"#f3f3f3","vimeoColor":"00adef","vimeoPortrait":"0","vimeoTitle":"0","vimeoFullScreen":"1","vimeoByline":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10018, 'Content - RokBox', 'plugin', 'rokbox', 'content', 0, 1, 1, 0, '{"name":"Content - RokBox","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.6","description":"\\n        <div class=\\"rokbox-description\\">\\n        <img src=\\"..\\/plugins\\/system\\/rokbox\\/assets\\/admin\\/images\\/rokbox.jpg\\" class=\\"img-padding\\" \\/><h1>RokBox2<\\/h1>\\n        <p>Auto generates thumbnails of <strong>local images<\\/strong> that can be used as content for your RokBox2 links. All thumbnails generated are <strong>responsive<\\/strong> so that they can be easily adapted to any device. RokBox2 Content plugins also provides backward compatibility for the old discontinued RokBox1 that allowed writing snippets through the <code>{rokbox}<\\/code> syntax.<\\/p>\\n\\n        <p class=\\"note\\"><strong>NOTE:<\\/strong> RokBox2 comes with 3 plugins: <strong>Content<\\/strong>, <strong>System<\\/strong> and <strong>Editor Button<\\/strong>. Make sure to have a look at all three plugin manager pages to get an idea of what they do.<\\/p>\\n        <\\/div>\\n        ","group":""}', '{"remote_sizes":"0","thumb_ext":"_thumb","thumb_class":"album","thumb_custom":"0","thumb_dir":"cache","thumb_width":"150","thumb_height":"100","thumb_quality":"90"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10020, 'RokCandy', 'component', 'com_rokcandy', '', 1, 1, 0, 0, '{"name":"RokCandy","type":"component","creationDate":"November 11, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.1","description":"\\n\\t\\tRokCandy is a simple yet powerful macro system for Joomla 1.6.  It provides the ability to create and categorize macros that can be used throughout your site.\\n\\t","group":""}', '{"forcecache":"0","adminenabled":"0","editenabled":"0","contentPlugin":"0","disabled":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 'Button - RokCandy', 'plugin', 'rokcandy', 'editors-xtd', 0, 1, 1, 0, '{"name":"Button - RokCandy","type":"plugin","creationDate":"November 11, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.1","description":"This is an Editor Button to allow selection of RokCandy macros","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10022, 'System - RokCandy', 'plugin', 'rokcandy', 'system', 0, 1, 1, 0, '{"name":"System - RokCandy","type":"plugin","creationDate":"November 11, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.1","description":"This is the RokCandy system plugin that performs the macro replacement","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10025, 'System - RokCommon', 'plugin', 'rokcommon', 'system', 0, 1, 1, 0, '{"name":"System - RokCommon","type":"plugin","creationDate":"October 16, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"3.1.7","description":"RokCommon System Plugin","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10026, 'RokGallery', 'component', 'com_rokgallery', '', 1, 1, 0, 0, '{"name":"RokGallery","type":"component","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.28","description":"Parent for all PHP based projects","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 'RokGallery Module', 'module', 'mod_rokgallery', '', 0, 1, 1, 0, '{"name":"RokGallery Module","type":"module","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.28","description":"Module for displaying RokGallery","group":""}', '{"link":"0","default_menuitem":"0","title":"false","caption":"false","sort_by":"gallery_ordering","sort_direction":"ASC","limit_count":"10","style":"light","layout":"grid","columns":"1","arrows":"onhover","navigation":"thumbnails","animation_type":"random","animation_duration":"500","autoplay_enabled":"0","autoplay_delay":"7","showcase_arrows":"onhover","showcase_image_position":"left","showcase_imgpadding":"0","showcase_animation_type":"random","showcase_captionsanimation":"crossfade","showcase_animation_duration":"500","showcase_autoplay_enabled":"0","showcase_autoplay_delay":"7","showcase_responsive_arrows":"onhover","showcase_responsive_image_position":"left","showcase_responsive_imgpadding":"0","showcase_responsive_animation_type":"random","showcase_responsive_captionsanimation":"crossfade","showcase_responsive_animation_duration":"500","showcase_responsive_autoplay_enabled":"0","showcase_responsive_autoplay_delay":"7","cache":"0","module_cache":"1","cache_time":"900","moduleclass_sfx":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 'Button - RokGallery', 'plugin', 'rokgallery', 'editors-xtd', 0, 1, 1, 0, '{"name":"Button - RokGallery","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.28","description":"This is an Editor Button to allow selection of RokGallery Slices","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10029, 'System - RokGallery', 'plugin', 'rokgallery', 'system', 0, 1, 1, 0, '{"name":"System - RokGallery","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.28","description":"A system level support plugin for RokGallery.","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10031, 'RokCommon', 'library', 'lib_rokcommon', '', 0, 1, 1, 0, '{"name":"RokCommon","type":"library","creationDate":"October 16, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"3.1.7","description":"RokCommon Shared Library","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10032, 'RokSprocket', 'component', 'com_roksprocket', '', 1, 1, 0, 0, '{"name":"RokSprocket","type":"component","creationDate":"November 6, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.5","description":"Parent for all PHP based projects","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 'RokSprocket Module', 'module', 'mod_roksprocket', '', 0, 1, 1, 0, '{"name":"RokSprocket Module","type":"module","creationDate":"November 6, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.5","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10034, 'System - RokSprocket', 'plugin', 'roksprocket', 'system', 0, 1, 1, 0, '{"name":"System - RokSprocket","type":"plugin","creationDate":"November 6, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.0.5","description":"RokSprocket System Plugin","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10035, 'Content - RokInjectModule', 'plugin', 'rokinjectmodule', 'content', 0, 1, 1, 0, '{"name":"Content - RokInjectModule","type":"plugin","creationDate":"April 22, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"1.5","description":"RokInjectModule Content Plugin.  Use format [module-{moduleid}] in your article to inject a module. You can also specify a style, eg: [module-28 style=xhtml]","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10036, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":""}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10037, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":""}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10038, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":""}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 'System - RokUpdater', 'plugin', 'rokupdater', 'system', 0, 1, 1, 0, '{"name":"System - RokUpdater","type":"plugin","creationDate":"November 5, 2013","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2013 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"1.0.8","description":"\\n        \\n        <div class=\\"updater-description\\">\\n        <img src=\\"..\\/plugins\\/system\\/rokupdater\\/assets\\/images\\/RokUpdater_154.png\\" class=\\"img-padding\\" \\/><h1>RokUpdater<\\/h1>\\n        <p>RokUpdater allows you to update RocketTheme extensions you have access to with your RocketTheme subscription.<\\/p>\\n        <\\/div>\\n        \\n    ","group":""}', '{"show_auth_on_updates":"1","hide_unavailable":"0","fallback_to_http_for_auth":"0","debugloglevel":"63"}', '{"access_token":null,"expires":null,"scope":null,"refresh_token":null,"token_type":null,"notice":null,"username":null,"subscriptions":[]}', '', 0, '0000-00-00 00:00:00', 10, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`,`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_path` (`path`(255)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 131, 0, '*', 0),
(2, 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 0, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'menu', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'menu', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 0, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'menu', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'menu', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 0, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 11, 16, 0, '*', 1),
(8, 'menu', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 0, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 12, 13, 0, '*', 1),
(9, 'menu', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 0, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 14, 15, 0, '*', 1),
(10, 'menu', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 0, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 17, 22, 0, '*', 1),
(11, 'menu', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 18, 19, 0, '*', 1),
(12, 'menu', 'com_messages_read', 'Read Private Message', '', 'Messaging/Read Private Message', 'index.php?option=com_messages', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-read', 0, '', 20, 21, 0, '*', 1),
(13, 'menu', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 23, 28, 0, '*', 1),
(14, 'menu', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 24, 25, 0, '*', 1),
(15, 'menu', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 0, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 26, 27, 0, '*', 1),
(16, 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 0, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 41, 42, 0, '*', 1),
(17, 'menu', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 0, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 33, 34, 0, '*', 1),
(18, 'menu', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', 0, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 35, 40, 0, '*', 1),
(19, 'menu', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', 0, 18, 2, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 36, 37, 0, '*', 1),
(20, 'menu', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 0, 18, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks-cat', 0, '', 38, 39, 0, '*', 1),
(21, 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 0, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 31, 32, 0, '*', 1),
(22, 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 0, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 43, 44, 0, '*', 1),
(23, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 0, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 45, 46, 0, '', 1),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"1","num_intro_articles":"3","num_columns":"3","num_links":"0","multi_column_order":"1","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"2","show_pagination_results":"1","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"September 2012 Template Demo","show_page_heading":0,"page_heading":"","pageclass_sfx":" sep12-home","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 29, 30, 1, '*', 0),
(103, 'main', 'RokCandy', 'rokcandy', '', 'rokcandy', 'index.php?option=com_rokcandy', 'component', 0, 1, 1, 10020, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_rokcandy/assets/rokcandy-icon-16.png', 0, '', 45, 50, 0, '', 1),
(104, 'main', 'Macros', 'macros', '', 'rokcandy/macros', 'index.php?option=com_rokcandy', 'component', 0, 103, 2, 10020, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_rokcandy/assets/rokcandy-icon-16.png', 0, '', 46, 47, 0, '', 1),
(105, 'main', 'Categories', 'categories', '', 'rokcandy/categories', 'index.php?option=com_categories&extension=com_rokcandy', 'component', 0, 103, 2, 10020, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_rokcandy/assets/icon-16-category.png', 0, '', 48, 49, 0, '', 1),
(106, 'main', 'RokGallery', 'rokgallery', '', 'rokgallery', 'index.php?option=com_rokgallery', 'component', 0, 1, 1, 10026, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_rokgallery/assets/images/rokgallery_16x16.png', 0, '', 51, 52, 0, '', 1),
(108, 'mainmenu', 'Features', 'features', '', 'features', 'index.php?option=com_content&view=article&id=1', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 53, 84, 0, '*', 0),
(109, 'mainmenu', 'Module Positions', 'module-positions', '', 'features/module-positions', 'index.php?option=com_content&view=article&id=2', 'component', 1, 108, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 8, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 54, 55, 0, '*', 0),
(110, 'mainmenu', 'Module Variations', 'module-variations', '', 'features/module-variations', 'index.php?option=com_content&view=article&id=3', 'component', 1, 108, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 9, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 56, 57, 0, '*', 0),
(111, 'mainmenu', 'Typography', 'typography', '', 'features/typography', 'index.php?option=com_content&view=article&id=4', 'component', 1, 108, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 58, 59, 0, '*', 0),
(112, 'mainmenu', 'Menu Options', 'menu-options', '', 'features/menu-options', 'index.php?option=com_content&view=article&id=5', 'component', 1, 108, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"2","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"360","fusion_column_widths":"180,180","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 60, 77, 0, '*', 0),
(113, 'mainmenu', 'Extensions', 'extensions', '', 'features/extensions', 'index.php?option=com_content&view=article&id=6', 'component', 1, 108, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 78, 79, 0, '*', 0),
(114, 'mainmenu', 'Tutorials', 'tutorials', '', 'tutorials', 'index.php?option=com_content&view=article&id=7', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 85, 94, 0, '*', 0),
(115, 'mainmenu', 'Installation', 'installation', '', 'tutorials/installation', 'index.php?option=com_content&view=article&id=8', 'component', 1, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 86, 87, 0, '*', 0),
(116, 'mainmenu', 'Logo Editing', 'logo-editing', '', 'tutorials/logo-editing', 'index.php?option=com_content&view=article&id=9', 'component', 1, 114, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 88, 89, 0, '*', 0),
(117, 'mainmenu', 'Styles', 'styles', '', 'styles', 'index.php?option=com_content&view=article&id=10', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"2","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"280","fusion_column_widths":"140,140","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 95, 112, 0, '*', 0),
(118, 'mainmenu', 'J! Stuff', 'j-stuff', '', 'j-stuff', 'index.php?option=com_content&view=article&id=11', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 113, 122, 0, '*', 0),
(119, 'mainmenu', '404 Error Page', '2012-08-09-12-40-20', '', 'features/2012-08-09-12-40-20', 'index.php/404', 'url', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 80, 81, 0, '*', 0),
(120, 'mainmenu', 'More Details', '2012-08-09-12-41-10', '', 'features/2012-08-09-12-41-10', 'http://www.rockettheme.com/joomla-templates/fracture', 'url', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 1, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 82, 83, 0, '*', 0),
(121, 'mainmenu', 'Forum Guides', '2012-08-09-12-41-59', '', 'tutorials/2012-08-09-12-41-59', 'http://www.rockettheme.com/forum/index.php?f=662&rb_v=viewforum', 'url', 1, 114, 2, 0, 0, '0000-00-00 00:00:00', 1, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"130","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 90, 91, 0, '*', 0),
(122, 'mainmenu', 'Gantry Framework', '2012-08-09-12-42-23', '', 'tutorials/2012-08-09-12-42-23', 'http://www.gantry-framework.org/documentation', 'url', 1, 114, 2, 0, 0, '0000-00-00 00:00:00', 1, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 92, 93, 0, '*', 0),
(123, 'mainmenu', 'Member Access', 'member-access', '', 'j-stuff/member-access', 'index.php?option=com_users&view=login', 'component', 1, 118, 2, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"login_redirect_url":"","logindescription_show":"1","login_description":"The RocketTheme Joomla Template Club features exclusive access to professional Joomla templates to help transform your Joomla based site and set you apart from the competition. Complimentary access to to the new RocketTheme Extensions Club is provided for all RocketTheme Joomla Club members.","login_image":"","logout_redirect_url":"","logoutdescription_show":"1","logout_description":"","logout_image":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Member Access","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 114, 115, 0, '*', 0),
(124, 'mainmenu', 'Category Blog', 'category-blog', '', 'j-stuff/category-blog', 'index.php?option=com_content&view=category&layout=blog&id=12', 'component', 1, 118, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 116, 117, 0, '*', 0),
(125, 'mainmenu', 'Web Links', 'web-links', '', 'j-stuff/web-links', 'index.php?option=com_weblinks&view=category&id=14', 'component', 1, 118, 2, 21, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_subcat_desc":"","show_cat_num_links":"","show_pagination_limit":"0","show_headings":"","show_link_description":"","show_link_hits":"","show_pagination":"","show_pagination_results":"","show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 118, 119, 0, '*', 0),
(126, 'mainmenu', 'Contact Us', 'contact-us', '', 'j-stuff/contact-us', 'index.php?option=com_contact&view=contact&id=1', 'component', -2, 118, 2, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"presentation_style":"plain","show_contact_category":"","show_contact_list":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"0","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"0","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 120, 121, 0, '*', 0),
(127, 'mainmenu', 'Menu Examples', 'menu-examples', '', 'features/menu-options/menu-examples', 'index.php?Itemid=', 'alias', 1, 112, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"112","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"1","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 61, 68, 0, '*', 0),
(128, 'mainmenu', 'Menu Types', 'menu-types', '', 'features/menu-options/menu-types', 'index.php?Itemid=', 'alias', 1, 112, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"112","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"1","fusion_children_type":"menuitems","fusion_modules":"17","fusion_module_positions":"","splitmenu_item_subtext":""}', 69, 76, 0, '*', 0),
(129, 'mainmenu', 'Child Item', 'child-item', '', 'features/menu-options/menu-examples/child-item', 'index.php?Itemid=', 'alias', 1, 127, 4, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"112","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"130","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 62, 63, 0, '*', 0),
(130, 'mainmenu', 'Menu Icon', 'menu-icon', '', 'features/menu-options/menu-examples/menu-icon', 'index.php?Itemid=', 'alias', 1, 127, 4, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"112","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"icon-like.png","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"130","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 64, 65, 0, '*', 0),
(131, 'mainmenu', 'Module Menu', 'module-menu', '', 'features/menu-options/menu-examples/module-menu', 'index.php?Itemid=', 'alias', 1, 127, 4, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"112","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"250","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"modulepos","fusion_modules":"92","fusion_module_positions":"menu-mod","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 66, 67, 0, '*', 0),
(132, 'mainmenu', 'FusionMenu', '2012-08-09-12-56-27', '', 'features/menu-options/menu-types/2012-08-09-12-56-27', 'index.php?option=com_content&view=article&id=5&Itemid=112&menu-type=fusionmenu', 'url', 1, 128, 4, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_item_subtext":""}', 70, 71, 0, '*', 0),
(133, 'mainmenu', 'SplitMenu', '2012-08-09-12-56-28', '', 'features/menu-options/menu-types/2012-08-09-12-56-28', 'index.php?option=com_content&view=article&id=5&Itemid=112&menu-type=splitmenu', 'url', 1, 128, 4, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_item_subtext":""}', 72, 73, 0, '*', 0),
(134, 'mainmenu', 'No Menu', '2012-08-09-12-56-29', '', 'features/menu-options/menu-types/2012-08-09-12-56-29', 'index.php?option=com_content&view=article&id=5&Itemid=112&menu-type=nomenu', 'url', 1, 128, 4, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_item_subtext":""}', 74, 75, 0, '*', 0),
(135, 'copyrightmenu', 'Guides', '2012-08-31-16-29-13', '', '2012-08-31-16-29-13', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"114","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 123, 124, 0, '*', 0),
(136, 'copyrightmenu', 'Addons', 'integrated-extensions', '', 'integrated-extensions', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"113","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 125, 126, 0, '*', 0),
(137, 'copyrightmenu', 'Fusion', 'megamenu', '', 'megamenu', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"112","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 127, 128, 0, '*', 0),
(138, 'copyrightmenu', 'Presets', 'template-variations', '', 'template-variations', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"117","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"92","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"130","splitmenu_item_subtext":""}', 129, 130, 0, '*', 0),
(139, 'mainmenu', 'Preset 1', '2012-09-02-17-05-34', '', 'styles/2012-09-02-17-05-34', '?presets=preset1', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 96, 97, 0, '*', 0),
(140, 'mainmenu', 'Preset 2', '2012-09-02-17-05-35', '', 'styles/2012-09-02-17-05-35', '?presets=preset2', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 98, 99, 0, '*', 0),
(141, 'mainmenu', 'Preset 3', '2012-09-02-17-05-36', '', 'styles/2012-09-02-17-05-36', '?presets=preset3', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 100, 101, 0, '*', 0),
(142, 'mainmenu', 'Preset 4', '2012-09-02-17-05-37', '', 'styles/2012-09-02-17-05-37', '?presets=preset4', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 102, 103, 0, '*', 0),
(143, 'mainmenu', 'Preset 5', '2012-09-02-17-05-38', '', 'styles/2012-09-02-17-05-38', '?presets=preset5', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 104, 105, 0, '*', 0),
(144, 'mainmenu', 'Preset 6', '2012-09-02-17-05-39', '', 'styles/2012-09-02-17-05-39', '?presets=preset6', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 106, 107, 0, '*', 0),
(145, 'mainmenu', 'Preset 7', '2012-09-02-17-05-40', '', 'styles/2012-09-02-17-05-40', '?presets=preset7', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 108, 109, 0, '*', 0),
(146, 'mainmenu', 'Preset 8', '2012-09-02-17-05-41', '', 'styles/2012-09-02-17-05-41', '?presets=preset8', 'url', 1, 117, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"fusion_item_subtext":"","fusion_customimage":"","fusion_customclass":"","fusion_columns":"1","fusion_distribution":"even","fusion_manual_distribution":"","fusion_dropdown_width":"","fusion_column_widths":"","fusion_children_group":"0","fusion_children_type":"menuitems","fusion_modules":"100","fusion_module_positions":"","splitmenu_menu_entry_type":"normal","splitmenu_menu_module":"100","splitmenu_item_subtext":""}', 110, 111, 0, '*', 0),
(147, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 0, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 45, 46, 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES
(1, 'mainmenu', 'Main Menu', 'The main menu for the site'),
(2, 'copyrightmenu', 'Copyright Menu', 'Copyright Menu');

-- --------------------------------------------------------

--
-- Table structure for table `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{"layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(86, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(92, 0, 'Module in Menu', '', '<p>This is an example of a module being displayed inside the menu <strong>dropdowns</strong>.</p>\r\n<p><a href="#" class="readon"><span>Read More</span></a></p>', 1, 'menu-mod', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(93, 0, 'Copyright Menu', '', '', 1, 'copyright-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"copyrightmenu","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"horizmenu nomarginleft nomarginright nopaddingleft nopaddingright hidden-phone","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(94, 0, 'Features Footer', '', '<div class="rt-demo-width-66">\r\n  <div class="rt-demo-space">\r\n    <h3>All the Features - in One Complete List</h3>\r\n    <h4 class="nomargintop">Fracture Template</h4>\r\n    \r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li>8 Preset Styles</li>\r\n          <li>84 Module Positions</li>\r\n          <li>Powered by Gantry 4</li>\r\n          <li>Fusion with MegaMenu</li>\r\n          <li>SplitMenu</li>\r\n          <li>Custom Typography</li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n    \r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li>RokSprocket Styling</li>\r\n          <li>K2 Styling</li>\r\n          <li>Gantry Framework</li>\r\n          <li>RTL Layout Support</li>\r\n          <li>Major Browsers Support</li>\r\n          <li>HTML5, CSS3, LESS CSS</li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n    \r\n    <div class="clear"></div>\r\n    \r\n    <h4 class="nomargintop">Gantry Framework</h4>\r\n\r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li>CSS Grid Framework</li>\r\n          <li>Stunning Admin Interface</li>\r\n          <li>Source Ordered Mainbody</li>\r\n          <li>Extensive Administrator Interface</li>\r\n          <li>Image Smart Loading</li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n    \r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li>Versatile Layout</li>\r\n          <li>Grid RTL Support</li>\r\n          <li>Built-in GZip and General Caching</li>\r\n          <li>Google Web Fonts Support</li>   \r\n          <li>Per Browser based CSS / JS control</li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n    \r\n    <div class="clear"></div>\r\n  </div>\r\n</div>\r\n\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <h3>Requirements</h3>\r\n    <ul class="checkmark">\r\n      <li><strong>Apache 2.x or Microsoft IIS 7</strong><br />\r\n        <em>Most widely deployed web server software which is required for Joomla!</em></li>\r\n      <li><strong>PHP 5.3.x</strong><br />\r\n        <em>General-purpose server-side scripting language for web development.</em></li>\r\n      <li><strong>MySQL 5.0.4 or higher</strong><br />\r\n        <em>The most popular open-source database system.</em></li>\r\n      <li><strong>Joomla! 2.5.x</strong><br />\r\n        <em>Please download the latest version of Joomla! at <a class="normalfont nobold" href="http://www.joomla.org" target="_blank">Joomla! Official Site</a>.</em></li>\r\n      <li><strong>Gantry Framework</strong><br />\r\n        <em>Please ensure you are using the latest version of <a class="normalfont nobold" href="http://www.gantry-framework.org" target="_blank">Gantry Framework</a>.</em></li>\r\n      <li><strong>RokNavMenu Module</strong><br />\r\n        <em>Essential ingredient of <a class="normalfont nobold" href="index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=112">powerful menu</a> system of RocketTheme templates.</em></li>\r\n    </ul>\r\n  <div class="clear"></div>\r\n  </div>\r\n</div>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(95, 0, 'Gantry Grid Distribution', '', '<p>Configure at <strong>Admin &rarr; Extensions &rarr; Template Manager &rarr; rt_fracture</strong>, then go to <strong>Layouts</strong> to set the grid widths and allocated positions.</p>\r\n\r\n<div class="rt-image">\r\n  <img src="images/rocketlauncher/module-positions/grid-distribution.jpg" alt="image" />\r\n</div>', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(96, 0, 'Injected Gantry Features', '', '<div class="rt-image">\r\n  <img alt="Non-Standard Elements" src="images/rocketlauncher/module-positions/injected-features.jpg" />\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div>\r\n\r\n<p class="hidden-tablet">In the Gantry framework we use the term Feature to mean a specific bit of functionality. Features are flexible enough that they can be used to perform almost any kind of logic you would need.</p>\r\n\r\n<p class="nomarginbottom">There are <strong>Features</strong> that are injected into a position when enabled, and are stacked vertically; which includes: Logo, Date, Font Sizer, Login Panel, Popup Module, Branding, Copyright, More Articles.</p>', 11, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(97, 0, 'MainBody/Sidebar Layouts', '', '<p>Configure at <strong>Admin &rarr; Extensions &rarr; Template Manager &rarr; rt_fracture</strong>, then go to <strong>Layouts</strong> tab and set the varying Mainbody/Sidebar layout possibilities.</p>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/module-positions/position-config-mb1.jpg" alt="image"/>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/module-positions/position-config-mb2.jpg" alt="image"/>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/module-positions/position-config-mb3.jpg" alt="image"/>\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div><br />\r\n\r\n<p class="attention">Note: If no modules are assigned to the Sidebar positions, the Mainbody will become full width.</p>\r\n\r\n<div class="rt-image">\r\n  <img alt="Module Positions" src="images/rocketlauncher/module-positions/gantry-layout.jpg" />\r\n</div>\r\n', 1, 'mainbottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(98, 0, 'Basic: Using Layouts', '', '<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a rel="rokbox[745 505]" title="Video Tutorial :: Using Gantry Layouts" href="http://www.gantry-framework.org/videos/joomla/g4-module-widths.mp4">\r\n      <span class="rt-image">\r\n        <img src="images/rocketlauncher/module-positions/using-layouts.jpg" alt="Using Layouts" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-75">\r\n  <div class="rt-demo-space">\r\n    <p>To find out about <strong>Gantry Layouts</strong> and <strong>Module Widths</strong>, check out this screencast which covers basic concepts of configuring layout with a combination of module setting and the Gantry layout control.</p>\r\n\r\n    <a class="readon smallmargintop" href="http://www.gantry-framework.org/documentation/joomla/configure/layouts" target="_blank"><span>View : Using Layouts</span></a>\r\n  </div>    \r\n</div>\r\n\r\n<div class="clear"></div>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(99, 0, 'Advanced: Add Positions', '', '<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a rel="rokbox[745 505]" title="Video Tutorial :: Module Positions" href="http://www.gantry-framework.org/media/videos/module_positions.mov">\r\n      <span class="rt-image">\r\n      <img src="images/rocketlauncher/module-positions/adding-module-positions.jpg" alt="Using Layouts" />\r\n      </span>  \r\n    </a>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-75">\r\n  <div class="rt-demo-space">\r\n    <p>Check out this quick screencast on <strong>Module Positions</strong> to get an overview of how module positions work within Gantry Framework. Click below button to learn how to <strong>add a new row of module positions</strong>.</p>\r\n\r\n    <a class="readon smallmargintop" href="http://www.gantry-framework.org/documentation/joomla/customize/adding-module-positions" target="_blank"><span>Learn : Adding Positions</span></a>\r\n  </div>    \r\n</div>\r\n\r\n<div class="clear"></div>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(100, 0, 'title1', '', '<p>An example module using the <strong>title1</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 1, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(101, 0, 'title3', '', '<p>An example module using the <strong>title3</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>\r\n\r\n<p class="rt-demo-visible-wide nomarginbottom">Lorem ipsum dolor sit amet donec.</p>', 3, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(102, 0, 'box1', '', '<p>An example module using the <strong>box1</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 4, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box1","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(103, 0, 'box3', '', '<p>An example module using the <strong>box3</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 6, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(104, 0, 'title1 icon-user', '', '<p>An example module using the <strong>title1 icon-user</strong> module suffix.</p>\r\n\r\n<p class="visible-desktop">Lorem ipsum dolor sit amet donec.</p>', 1, 'content-bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1 icon-user","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(105, 0, 'title4', '', '<p>An example module using the <strong>title4</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 3, 'content-bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(106, 0, 'box2', '', '<p>An example module using the <strong>box2</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 4, 'content-bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(107, 0, 'box4', '', '<p>An example module using the <strong>box4</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 5, 'content-bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(108, 0, 'box5', '', '<p>An example module using the <strong>box5</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 7, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box5","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(110, 0, 'Using a Suffix', '', '<p>Enter any available suffixes at <strong>Extensions &rarr; Module Manager &rarr; <em>Module</em> &rarr; Module Class Suffix</strong>.</p>\r\n<p class="notice nomarginbottom">You can compound multiple suffixes together such as: <strong><em>box1 title3</em></strong>.</p>', 2, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(111, 0, 'box1 title4', '', '<p>An example module using the <strong>box1 title4</strong> module suffix.</p>\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>\r\n<a href="#" class="readon"><span>More</span></a>', 10, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box1 title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(113, 0, 'box3 title2', '', '<p>An example module using the <strong>box3 title2</strong> module suffix.</p>\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>\r\n<a href="#" class="readon"><span>More</span></a>', 14, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box3 title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(114, 0, 'box5 title3', '', '<p>An example module using the <strong>box5 title3</strong> module suffix.</p>\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>\r\n<a href="#" class="readon"><span>More</span></a>', 15, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box5 title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(115, 0, 'Standard Variations: 25 Additional Module Class Suffixes', '', '<div class="rt-demo-grid-4 nomarginleft">\r\n  <ul class="nomarginbottom nomarginleft">\r\n    <li><strong>rt-center:</strong> centres the content of the module.</li>\r\n    <li><strong>shadow2-10</strong> adds varying shadows around the module.</li>\r\n    <li><strong>square and basic:</strong> changes the border style of the module.</li>\r\n  </ul>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4">\r\n  <ul class="nomarginbottom nomarginleft nomarginright">\r\n    <li><strong>standardcase, uppercase, lowercase:</strong> change the case of the module title.</li>  \r\n    <li><strong>nomargintop, nomarginright, nomarginbottom, nomarginleft, nomarginall:</strong> removes the various margins around the module.</li>\r\n  </ul>\r\n</div>\r\n\r\n<div class="rt-demo-grid-4 nomarginright">\r\n  <ul class="nomarginbottom nomarginright">\r\n    <li><strong>nopaddingtop, nopaddingright, nopaddingbottom, nopaddingleft, nopaddingall:</strong> removes the various paddings around the module</li>\r\n  </ul>\r\n</div>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(116, 0, 'Why Use RokCandy', '', '<p><strong>RokCandy</strong> is the ideal solution for those with <strong>limited coding skills</strong> or those who implement our templates for their clients.</p>\r\n\r\n<p>It is <strong>free</strong> from the WYSIWYG editors horrific filtering habits and can be easily pre-configured for your <strong>personal needs</strong> or the needs of your client.</p>\r\n\r\n<a href="http://www.rockettheme.com/extensions-joomla/rokcandy" class="readon" target="_blank"><span>Download : RokCandy</span></a>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(117, 0, 'Video : Using Typography', '', '<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="http://www.rockettheme.com/video/joomla15/using-typography-joomla15.mov" title="Video Tutorial :: Joomla Using Typography Video Tutorial" rel="rokbox[540 380]">\r\n      <span class="rt-image">\r\n        <img src="images/rocketlauncher/typography/using-typography.jpg" alt="Using Typography" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-75">\r\n  <div class="rt-demo-space">\r\n    <p>Check out this quick screencast to learn how to use RokCandy to enhance your Joomla! content. The tags are very easy to learn and this guide shows you how to use all the styles.</p>\r\n    <a href="http://www.rockettheme.com/video/joomla15/using-typography-joomla15.mov" title="Video Tutorial :: Joomla Using Typography Video Tutorial" rel="rokbox[540 380]" class="readon"><span>Watch : Using Typography</span></a>\r\n  </div>    \r\n</div>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(118, 0, 'Set Menu Type', '', '<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n      <p class="rt-demo-visible-wide">RokNavMenu provides a feature rich platform for extending the menu, allowing for overrides and plugins for the menu itself, in addition to versatile theming capabilities and so much more.</p>\r\n  	\r\n    <p>To find all the parameters for FusionMenu &amp; SplitMenu on Fracture template, such as transitions, duration &amp; sublevel position, please navigate to:</p>\r\n    \r\n    <ul class="dots">\r\n      <li><strong>Extensions &rarr; Template Manager &rarr; rt_fracture</strong></li>\r\n      <li>Then go to <strong>Menu</strong> tab, and set the Menu parameters</li>\r\n    </ul>\r\n    \r\n    <p class="largemargintop attention">Descriptions of each template parameter can be seen when you mouseover the label of each option.</p>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/menu-options/menu-setting.jpg" alt="Set Menu" />\r\n    </div>\r\n  </div>\r\n</div>', 1, 'maintop-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(119, 0, 'Fusion Menu', '', '<p>A Mootools enhanced CSS dropdown menu, with multi-columns, icons and more.</p>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=112&amp;menu-type=fusionmenu" class="readon"><span>FusionMenu</span></a>', 5, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-align-justify","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(120, 0, 'Split Menu', '', '<p>A static menu system that displays 1st level items in the main horizontal menu and all children in the Sidebar.</p>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=112&amp;menu-type=splitmenu" class="readon"><span>SplitMenu</span></a>', 6, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-list","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(121, 0, 'No Menu', '', '<p>An option to disable the menu, allowing for normal module use of the navigation position.</p>', 7, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(122, 0, 'SubText Line', '', '<p>The option that allows you to insert additional text to the Menu Item Title. There is separate styling for this, making it useful for adding brief descriptions to menu items.</p>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(123, 0, 'Menu Icon', '', '<p>RokNavMenu provides the option to display a small icon image for the menu item. The menu icon can be displayed both for the parent items and the child items.</p>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(124, 0, 'Multi-Columns', '', '<p>Who needs a single dropdown column when you can have as many as you want? Using the built-in configurable parameters, you can make incredible multi column dropdowns.</p>', 1, 'footer-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(125, 0, 'Extensions Footer', '', '<div class="rt-demo-width-70">\r\n  <div class="rt-demo-space">\r\n    <h3>All RocketTheme Extensions</h3>\r\n    <p>Many of our extensions were developed to accompany RocketTheme templates but we have now created versions that are intended to work independently of our templates if you wish.</p>\r\n\r\n    <h4 class="nomarginbottom">Club Extensions</h4>\r\n    \r\n    <div class="rt-demo-width-33">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokgallery" target="_blank">RokGallery</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokstock" target="_blank">RokStock</a></li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n    \r\n    <div class="rt-demo-width-33">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">  \r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokminievents" target="_blank">RokMiniEvents</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokweather" target="_blank">RokWeather</a></li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n\r\n    <div class="rt-demo-width-33">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokpad" target="_blank">RokPad</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokfeaturetable" target="_blank">RokFeatureTable</a></li>\r\n        </ul>  \r\n      </div>\r\n    </div>    \r\n    \r\n    <div class="clear"></div>\r\n    \r\n    <h4 class="nomargintop nomarginbottom">Free Extensions</h4>\r\n\r\n    <div class="rt-demo-width-33">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/roksprocket" target="_blank">RokSprocket</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokbox" target="_blank">RokBox</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokbooster" target="_blank">RokBooster</a></li>\r\n        </ul>\r\n      </div>\r\n    </div>   \r\n\r\n    <div class="rt-demo-width-33">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/roknavmenu" target="_blank">RokNavMenu</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokquickcart" target="_blank">RokQuickCart</a></li>\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokcandy" target="_blank">RokCandy</a></li>\r\n        </ul>\r\n      </div>\r\n    </div>   \r\n\r\n    <div class="rt-demo-width-33">\r\n      <div class="rt-demo-space">\r\n        <ul class="circle">\r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokajaxsearch" target="_blank">RokAjaxSearch</a></li>      \r\n          <li><a href="http://www.rockettheme.com/extensions-joomla/rokcomments" target="_blank">RokComments</a></li>\r\n        </ul>  \r\n      </div>\r\n    </div>            \r\n\r\n    <div class="clear"></div>\r\n  </div>\r\n</div>\r\n\r\n\r\n<div class="rt-demo-width-30">\r\n  <div class="rt-demo-space">\r\n    <h3>Download</h3>\r\n    \r\n    <p>You can download the extensions from:</p>\r\n    \r\n    <ul class="normalfont nomarginbottom checkmark">\r\n      <li><strong>Fracture Download Page:</strong><br /><strong>rt_fracture-extensions.zip</strong> for J2.5. Unzip the file, it contains all the extensions used for Fracture template.</li>\r\n      <li class="nomarginbottom"><strong>RocketTheme Extensions Page:</strong><br />Contains all individual extensions are available from the Extensions section of RokDownloads.</li>\r\n    </ul>\r\n    \r\n    <a href="http://www.rockettheme.com/extensions-downloads/" target="_blank" class="readon largemargintop"><span>Download : Extensions</span></a>\r\n  <div class="clear"></div>\r\n  </div>\r\n</div>\r\n', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(126, 0, 'Installation', '', '<p>Download and install the <strong>Bundle</strong> file if Gantry is not installed, use the Standard Template file if <a href="index.php?option=com_content&amp;view=article&amp;id=8&amp;Itemid=115">Gantry</a> is already present.</p>\r\n<a href="index.php?option=com_content&amp;view=article&amp;id=8&amp;Itemid=115" class="readon"><span>More Information</span></a>', 1, 'showcase-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1 icon-cogs hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(127, 0, 'Demo Replica', '', '<p>You may deploy a <a href="index.php?option=com_content&amp;view=article&amp;id=8&amp;Itemid=115">replica</a> of this month''s demo with ease, using the readily available <strong>RocketLauncher</strong> package.</p><br /><a href="index.php?option=com_content&amp;view=article&amp;id=8&amp;Itemid=115" class="readon"><span>More Information</span></a>', 1, 'showcase-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-copy hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(128, 0, 'Configuration', '', '<p>An overview of template files and instructions for installing &amp; configuring Fracture template.</p>\r\n<a class="readon" href="index.php?option=com_content&amp;view=article&amp;id=8&amp;Itemid=115"><span>Read More</span></a>', 1, 'content-top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(129, 0, 'Logo Editing', '', '<p>An overview for customizing your logo with your organization or company name and logo.</p>\r\n<a class="readon" href="index.php?option=com_content&amp;view=article&amp;id=9&amp;Itemid=116"><span>Read More</span></a>', 1, 'content-top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(130, 0, 'Video Documentation', '', '<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <ul class="dots">\r\n        <li><a class="nobold" href="http://www.gantry-framework.org/videos/joomla/g4-install.mp4" title="Video Tutorial :: Gantry Installation" rel="rokbox[503 356]">Install Gantry</a></li>\r\n		<li><a class="nobold" href="www.gantry-framework.org/videos/joomla/g4-features.mp4" title="Video Tutorial :: Gantry Features" rel="rokbox[504 336]">Gantry Features</a></li>\r\n		<li><a class="nobold" href="http://www.gantry-framework.org/media/videos/module_widths.mov" title="Video Tutorial :: Using Layouts" rel="rokbox[503 356]">Gantry Layout</a></li>\r\n		<li><a class="nobold" href="www.gantry-framework.org/videos/joomla/g4-module-positions.mp4" title="Video Tutorial :: Module Positions" rel="rokbox[503 356]">Module Positions</a></li>  \r\n    </ul>   \r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <ul>\r\n		<li><a class="nobold" rel="rokbox[503 356]" title="Video Tutorial :: Module Width" href="www.gantry-framework.org/videos/joomla/g4-module-widths.mp4">Module Width</a></li>\r\n		<li><a class="nobold" rel="rokbox[504 336]" title="Video Tutorial :: Module Variations" href="www.gantry-framework.org/videos/joomla/g4-module-variations.mp4">Module Variations</a></li>\r\n		<li><a class="nobold" rel="rokbox[504 336]" title="Video Tutorial :: Force Module Positionsr" href="www.gantry-framework.org/videos/joomla/g4-forcepos.mp4">Force<span class="rt-demo-visible-wide"> Module</span> Positions</a></li>\r\n		<li><a class="nobold" rel="rokbox[504 336](joomla15basic)" title="Video Tutorial :: Template Overrides" href="www.gantry-framework.org/videos/joomla/g4-overrides.mp4">Template Overrides</a></li>\r\n	</ul>   \r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<a href="http://www.gantry-framework.org/documentation" target="_blank" class="readon largemargintop smallmarginbottom"><span>View All</span></a>', 8, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4 title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(131, 0, 'Forum Guides', '', '<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <ul class="dots">\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174183&amp;rb_v=viewtopic" target="_blank">Editing the Logo</a></li>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174184&amp;rb_v=viewtopic" target="_blank">Template Text</a></li>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174185&amp;rb_v=viewtopic" target="_blank">RokBox Login</a></li>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174186&amp;rb_v=viewtopic" target="_blank">Popup Module</a></li>\r\n    </ul>   \r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <ul>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174187&amp;rb_v=viewtopic" target="_blank">Template Guide</a></li>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174188&amp;rb_v=viewtopic" target="_blank">Template FAQs</a></li>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174189&amp;rb_v=viewtopic" target="_blank">Responsive Classes</a></li>\r\n      <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174190&amp;rb_v=viewtopic" target="_blank">Demo Content</a></li>\r\n    </ul>   \r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<a class="readon largemargintop smallmarginbottom" target="_blank" href="http://www.rockettheme.com/forum/index.php?f=662&amp;rb_v=viewforum"><span>View All</span></a>', 6, 'content-bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box5 title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(132, 0, 'Joomla Docs', '', '<p>Joomla.org is an invaluable resource for general information on how to use, configure and modify Joomla.</p>\r\n<a href="http://docs.joomla.org" class="readon" target="_blank"><span>Read More</span></a>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-book hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(133, 0, 'Template Help', '', '<p>RocketTheme provides tutorials of template installation, RocketLauncher, and template related topics.</p>\r\n<a href="http://www.rockettheme.com/joomla-tutorials" class="readon" target="_blank"><span>Read More</span></a>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-question-sign hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(134, 0, 'Gantry Info', '', '<p>More extensive details of the Gantry Framework, inclusive of both written and video tutorials, please visit Gantry Site.</p>\r\n<a href="http://www.gantry-framework.org/" target="_blank" class="readon"><span>Learn More</span></a>', 1, 'footer-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-cog","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(135, 0, 'Requirements', '', '<ul class="checkmark nomarginbottom">\r\n  <li><strong>Apache 2.x or Microsoft IIS 7</strong></li>\r\n  <li><strong>PHP 5.3.x</strong></li>\r\n  <li><strong>MySQL 5.0.4 or higher</strong></li>\r\n  <li><strong>Joomla! 2.5.x</strong></li> \r\n  <li><strong>Gantry Framework</strong></li>\r\n  <li class="nomarginbottom"><strong>RokNavMenu Module</strong></li>\r\n</ul>', 4, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box3 title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(136, 0, 'RocketLauncher', '', '<p class="medmarginbottom"><strong>RocketLauncher</strong> is a customized <strong>Joomla</strong> install, that installs a <strong>replica</strong> of the <strong>demo</strong>.</p>\r\n<p class="alert nomarginbottom"><strong>Note</strong>: All sample content images will be replaced with blank versions in the RocketLauncher.</p>', 3, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4 title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(137, 0, 'Forum Guides', '', '<ul class="dots">\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174183&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to </span>Edit the Logo</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174184&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Changet </span>Template Text</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174185&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Enable </span>RokBox Login</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174186&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Activate </span>Popup Module</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174187&amp;rb_v=viewtopic" target="_blank">Template Guide<span class="rt-demo-visible-wide"> and Information</span></a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174188&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">Fracture </span>Template FAQs</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174189&amp;rb_v=viewtopic" target="_blank">Responsive Classes<span class="rt-demo-visible-wide"> in Fracture</span></a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174190&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Replicate </span>Demo Content</a></li>\r\n</ul>   \r\n\r\n<a class="readon largemargintop smallmarginbottom" target="_blank" href="http://www.rockettheme.com/forum/index.php?f=662&amp;rb_v=viewforum"><span>View All</span></a>', 17, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box5 title4 hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(138, 0, 'Video Docs', '', '<ul class="dots">\r\n  <li><a class="nobold" href="http://www.gantry-framework.org/videos/joomla/g4-install.mp4" title="Video Tutorial :: Gantry Installation" rel="rokbox[503 356]"><span class="rt-demo-visible-wide">How to </span>Install Gantry</a></li>\r\n  <li><a class="nobold" href="www.gantry-framework.org/videos/joomla/g4-features.mp4" title="Video Tutorial :: Gantry Features" rel="rokbox[504 336]"><span class="rt-demo-visible-wide">Find Out </span>Gantry Features</a></li>\r\n  <li><a class="nobold" href="http://www.gantry-framework.org/media/videos/module_widths.mov" title="Video Tutorial :: Using Layouts" rel="rokbox[503 356]"><span class="rt-demo-visible-wide">Learn </span>Gantry Layout</a></li>\r\n  <li><a class="nobold" href="www.gantry-framework.org/videos/joomla/g4-module-positions.mp4" title="Video Tutorial :: Module Positions" rel="rokbox[503 356]"><span class="rt-demo-visible-wide">Check Gantry </span>Module Positions</a></li>  \r\n  <li><a class="nobold" rel="rokbox[503 356]" title="Video Tutorial :: Module Width" href="www.gantry-framework.org/videos/joomla/g4-module-widths.mp4"><span class="rt-demo-visible-wide">How to Adjust </span>Module Width</a></li>\r\n  <li><a class="nobold" rel="rokbox[504 336]" title="Video Tutorial :: Module Variations" href="www.gantry-framework.org/videos/joomla/g4-module-variations.mp4"><span class="rt-demo-visible-wide">View Gantry </span>Module Variations</a></li>\r\n  <li><a class="nobold" rel="rokbox[504 336]" title="Video Tutorial :: Force Module Positionsr" href="www.gantry-framework.org/videos/joomla/g4-forcepos.mp4"><span class="rt-demo-visible-wide">How to </span>Force Module Positions</a></li>\r\n  <li><a class="nobold" rel="rokbox[504 336](joomla15basic)" title="Video Tutorial :: Template Overrides" href="www.gantry-framework.org/videos/joomla/g4-overrides.mp4"><span class="rt-demo-visible-wide">How to Do </span>Template Overrides</a></li>\r\n</ul>\r\n<a href="http://www.gantry-framework.org/documentation" target="_blank" class="readon largemargintop smallmarginbottom"><span>View All</span></a>', 18, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4 title4 hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(139, 0, 'Essential Files', '', '<ul class="list-icon checkmark normalfont nomarginbottom">\r\n  <li><strong>Gantry Framework</strong> - Download the latest version of Gantry Framework from <a href="" target="_blank">http://www.gantry-framework.org/</a> for update</li>\r\n  <li><strong>Template (Standalone)</strong> <em>rt_fracture.zip</em> - Standalone template file without the Gantry Framework (If Gantry is already installed)</li>\r\n  <li><strong>Template (Bundle)</strong> <em>rt_fracture-bundle.zip</em> - Template plus the Gantry Framework (If Gantry is not installed)</li>\r\n  <li><strong>RokNavMenu</strong> <em>rt_fracture-extensions.zip(<strong>unzip first</strong>) and find mod_roknavmenu.zip</em> - Required for the menu to work</li>\r\n</ul>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-check","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(140, 0, 'Additional Files', '', '<ul class="list-icon checkmark normalfont nomarginbottom">\r\n  <li><strong>Source PNG(s)</strong> <em>rt_fracture-sources.zip</em> - Adobe® Fireworks PNG source file(s) and any applicable fonts</li>\r\n  <li><strong>Source BG PNG(s)</strong> <em>rt_fracture-sources-bg.zip</em> - Adobe® Fireworks PNG BG source file(s) — <em>Only distributed if the template has complex BGs</em></li>\r\n  <li><strong>Extensions</strong> <em>rt_fracture-extensions.zip</em> - All extensions used for the template (Unzip first to find the individual extension)</li>\r\n  <li><strong>RocketLauncher</strong> <em>rt_fracture-rocketlauncher.zip</em> - Demo replica installer. RocketLauncher needs a fresh Joomla! installation</li>\r\n</ul>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-check","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*');
INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(141, 0, '8 Preset Styles - Preview Live', '', '<p class="notice">View all styles live by appending <strong>?presets=preset#</strong> or <strong>&amp;presets=preset#</strong> to the end of your URL such as <strong><a href="#">http://yoursite.com/index.php?presets=preset4</a></strong>.</p>\r\n\r\n<p>In sequential order, <strong>Preset 1 - Preset 8</strong>. Please click on the image to load a live example of each style variation.</p>\r\n\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset1">\r\n      <span class="rt-image">\r\n        <img alt="Preset 1" src="images/rocketlauncher/styles/ss1.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset2">\r\n      <span class="rt-image">\r\n        <img alt="Preset 2" src="images/rocketlauncher/styles/ss2.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset3">\r\n      <span class="rt-image">\r\n        <img alt="Preset 3" src="images/rocketlauncher/styles/ss3.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset4">\r\n      <span class="rt-image">\r\n        <img alt="Preset 4" src="images/rocketlauncher/styles/ss4.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset5">\r\n      <span class="rt-image">\r\n        <img alt="Preset 5" src="images/rocketlauncher/styles/ss5.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset6">\r\n      <span class="rt-image">\r\n        <img alt="Preset 6" src="images/rocketlauncher/styles/ss6.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset7">\r\n      <span class="rt-image">\r\n        <img alt="Preset 7" src="images/rocketlauncher/styles/ss7.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-25">\r\n  <div class="rt-demo-space">\r\n    <a href="index.php?option=com_content&amp;view=article&amp;id=10&amp;Itemid=117&amp;presets=preset8">\r\n      <span class="rt-image">\r\n        <img alt="Preset 8" src="images/rocketlauncher/styles/ss8.jpg" />\r\n      </span>\r\n    </a>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div>\r\n', 1, 'showcase-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(142, 0, 'Custom Presets', '', '<p class="hidden-tablet">Gantry provides the ability for you to create your own custom presets based on any parameter in the template administrator.</p>\r\n\r\n<ul class="circle-large">\r\n  <li>Go to <strong>Extensions &rarr; Template Manager &rarr; rt_fracture</strong></li>\r\n  <li>Click "<strong>Presets</strong>"</li>\r\n  <li>Configure the Settings</li>\r\n  <li>Click <strong>Save &rarr; Save Preset</strong></li>\r\n  <li>Follow the <strong>Preset Saver procedure</strong></li>\r\n</ul>\r\n\r\n<div class="rt-demo-visible-wide">\r\n<p class="notice">You can edit the prebuilt presets in the <strong>gantry.config.php</strong> file, or use the User Interface method outlined above.</p>\r\n</div>\r\n\r\n<a class="readon" href="http://www.gantry-framework.org/documentation/joomla/customize/custom-presets" target="_blank">Gantry Framework: Custom Presets</a>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-edit","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(143, 0, 'Preset Footer', '', '<div class="rt-image largemarginbottom"><img alt="image" src="images/rocketlauncher/styles/presets-save.jpg" /></div>\r\n<div class="clear"></div>\r\n<div class="rt-image"><img alt="image" src="images/rocketlauncher/styles/presets-create.jpg" /></div>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(144, 0, 'RocketTheme', '', '<div>\r\n  <h4 class="nomarginbottom">Joomla Templates Club</h4>\r\n  <p>Best known template club in JoomlaSphere</p>\r\n</div>\r\n\r\n<div>\r\n  <h4 class="nomarginbottom">Wordpress Themes Club</h4>\r\n  <p>Provides a stunningly unique blog design</p>\r\n</div>\r\n\r\n<div>\r\n  <h4 class="nomarginbottom">Magento Templates Club</h4>\r\n  <p>eCommerce template platform for growth</p>\r\n</div>  \r\n\r\n<div>\r\n  <h4 class="nomarginbottom">phpBB3 Styles Club</h4>\r\n  <p>Transform phpBB3 into a professional forum</p>\r\n</div>  \r\n\r\n<a href="https://www.rockettheme.com/join-a-club" class="readon" target="_blank"><span>Join Now</span></a>', 12, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box3 title4 hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(145, 0, 'Newsflash', '', '', 5, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news', 1, 1, '{"catid":["12"],"image":"0","item_title":"0","link_titles":"","item_heading":"h4","showLastSeparator":"1","readmore":"0","count":"1","ordering":"a.publish_up","layout":"_:default","moduleclass_sfx":"title2 icon-file nomargintop nopaddingtop hidden-phone","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(146, 0, 'Main Menu', '', '', 8, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"title2 icon-th hidden-phone","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(147, 0, 'Forum Guides', '', '<ul class="dots">\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174183&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to </span>Edit the Logo</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174184&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Changet </span>Template Text</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174185&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Enable </span>RokBox Login</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174186&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Activate </span>Popup Module</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174187&amp;rb_v=viewtopic" target="_blank">Template Guide<span class="rt-demo-visible-wide"> and Information</span></a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174188&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">Fracture </span>Template FAQs</a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174189&amp;rb_v=viewtopic" target="_blank">Responsive Classes<span class="rt-demo-visible-wide"> in Fracture</span></a></li>\r\n  <li><a class="nobold" href="http://www.rockettheme.com/forum/index.php?f=662&amp;t=174190&amp;rb_v=viewtopic" target="_blank"><span class="rt-demo-visible-wide">How to Replicate </span>Demo Content</a></li>\r\n</ul>   \r\n\r\n<a class="readon largemargintop smallmarginbottom" target="_blank" href="http://www.rockettheme.com/forum/index.php?f=662&amp;rb_v=viewforum"><span>View All</span></a>', 9, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4 title4 hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(148, 0, 'Login Form', '', '', 19, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","layout":"_:default","moduleclass_sfx":"box4 title2 icon-user hidden-phone","cache":"0"}', 0, '*'),
(149, 0, 'User Access', '', '', 20, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","layout":"_:default","moduleclass_sfx":"box5 title2 icon-user hidden-phone hidden-tablet","cache":"0"}', 0, '*'),
(150, 0, 'Who''s Online', '', '', 21, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_whosonline', 1, 1, '{"showmode":"0","layout":"_:default","moduleclass_sfx":"box5 title2 icon-heart hidden-phone","cache":"0","filter_groups":"0"}', 0, '*'),
(151, 0, 'Who''s Online', '', '', 22, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_whosonline', 1, 1, '{"showmode":"0","layout":"_:default","moduleclass_sfx":"title2 icon-heart hidden-tablet hidden-phone","cache":"0","filter_groups":"0"}', 0, '*'),
(152, 0, 'Responsive Layout', '', '<div class="rt-center largemargintop largemarginbottom">\r\n  <span class="promo2"><strong>Responsive</strong> Layout</span><br />\r\n  <span class="promo3">A responsive design automatically adapts itself to a particular viewing environment such as desktop, tablet or mobile, without the need for separate layouts for varying platforms</span>\r\n</div>\r\n\r\n<div class="rt-image rt-center largemargintop largemarginbottom">\r\n  <img alt="image" src="images/rocketlauncher/features/responsive.png" />\r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <h4 class="smallmarginbottom">Responsive Frameworks</h4>\r\n    <p>We use the responsive layout based on <a target="_blank" href="http://twitter.github.com/bootstrap/" class="external"><strong>Twitter''s Bootstrap Framework</strong></a>, with its collection of utility classes, to provide a flexible responsive design.</p>\r\n    <a href="http://www.rockettheme.com/blog/team/1550-responsive-design-and-gantry4" class="readon"><span class="icon-external-link"></span><span>Read Blog</span></a>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <h4 class="smallmarginbottom">RocketTheme Extensions</h4>\r\n    <p>The RokSprocket and RokGallery extensions that are built to work with a responsive layout and support mobile touch events, such as <strong>''swipe''</strong>.</p>\r\n    <a href="http://www.rockettheme.com/blog/team/1555-responsive-design-rocketthemes-extensions" class="readon"><span class="icon-external-link"></span><span>Read Blog</span></a>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <h4 class="smallmarginbottom">Media Queries in JavaScript</h4>\r\n    <p>We have created a new helper class, <strong>RokMediaQueries.js</strong>, which provides a unified system that enables extensions to add media query listeners.</p>\r\n    <a href="http://www.rockettheme.com/blog/team/1555-responsive-design-rocketthemes-extensions" class="readon"><span class="icon-external-link"></span><span>Read Blog</span></a>\r\n  </div>\r\n</div>', 1, 'showcase-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(153, 0, 'Responsive Layouts', '', '<div class="rt-image">\r\n  <img alt="image" src="images/rocketlauncher/features/responsive-1.jpg" />\r\n</div>\r\n\r\n<br />\r\n\r\n<span>Fracture''s responsive grid system is designed for desktop, tablet and smartphone systems, each with minor modifications to ensure compatibility in each mode. The table above shows the breakdown of screen resolutions and associated devices, and what layout characters are then applied to each.</span>', 1, 'utility-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(154, 0, 'Responsive Classes', '', '<div class="rt-image">\r\n  <img alt="image" src="images/rocketlauncher/features/responsive-2.jpg" />\r\n</div>\r\n\r\n<br />\r\n\r\n<span>Another useful feature available, via Bootstrap, is the collection of responsible utility classes that can be used to help tweak layouts by providing a simple method of showing or hiding modules. Insert the above module class suffixes into your module settings to show/hide a module for a particular mode.</span>', 1, 'utility-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(155, 0, 'Media Queries', '', '<p>In terms of media queries, the breakdown is:</p>\r\n<pre class="lines rt-pre-col2">\r\n/* Smartphones */\r\n@media (max-width: 480px) { ... }\r\n\r\n/* Smartphones to Tablets */\r\n@media (min-width: 481px) and (max-width: 767px) { ... }\r\n\r\n/* Tablets */\r\n@media (min-width: 768px) and (max-width: 959px) { ... }\r\n\r\n/* Desktop */\r\n@media (min-width: 960px) and (max-width: 1199px) { ... }\r\n\r\n/* Large Display */\r\n@media (min-width: 1200px) { ... }\r\n</pre>', 1, 'maintop-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(156, 0, 'Navigation', '', '<p class="rt-image rt-floatleft nomarginbottom">\r\n    <img src="images/rocketlauncher/features/responsive-nav.png" alt="image" />\r\n</p>\r\n\r\n<p>The menu system for a smartphone device will be that of a <strong>select-field</strong>. A select field is a great solution for this because most phones have nice native select UI elements. Using this method is necessary as to make the menu accessible on the mobile devices, as Fusion, and our other menu types, are simply too complex to render effectively on these devices. A new menu system will be created that is responsive, but will form part of Gantry</p>\r\n\r\n<p class="nomarginbottom hidden-tablet">All other sizes will use the normal menu system build on RokNavMenu, such as Fusion Menu or SplitMenu.</p>\r\n\r\n<div class="clear"></div>', 1, 'maintop-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(157, 0, 'RokBooster', '', '<p>Increase the speed of your site by enabling the RokBooster plug-in. RokBooster can dramatically reduce the number of HTTP calls a browser has to make, and sending those compressed files GZipped means your pages will load faster with less load on your server.</p>\r\n<a class="readon" href="http://www.rockettheme.com/extensions-joomla/rokbooster" target="_blank">Download: RokBooster</a>', 1, 'content-top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(158, 0, 'RokPad', '', '<p>RokPad provides advanced functions such as an Ajax saving action, syntax highlighting, configurable themes, multiple cursors and selections, shortcut keys, and many other incredible features that traditionally would only be found in a powerful desktop editor.</p>\r\n<a class="readon" href="http://www.rockettheme.com/extensions-joomla/rokpad" target="_blank">Download: RokPad</a>', 1, 'content-top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(159, 0, 'Extensions Showcase', '', '<div class="rt-demo-width-66">\r\n  <div class="rt-demo-space">\r\n    <span class="promo2">Rok<strong>Sprocket</strong></span><br />\r\n    <span class="promo3">A Revolutionary Content Module <span class="rt-extra-desc">with Multiple Layout Options</span></span><br />\r\n    <p class="largemargintop">RokSprocket is a revolutionary new extension for Joomla 2.5 designed to give you an incredible level of control over how you present your content. Sophisticated content filters, robust layout modes and options, integration with multiple content providers, and a streamlined no-nonsense interface all contribute to a powerful yet user friendly experience from start to finish.</p>\r\n  </div>\r\n  <div class="rt-extra-desc">\r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <ul class="checkmark">\r\n          <li><span>Multiple Layout Options</span></li>\r\n          <li><span>Multiple Content Providers</span></li>\r\n          <li><span>Advanced Cumulative Filters</span></li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n    <div class="rt-demo-width-50">\r\n      <div class="rt-demo-space">\r\n        <ul class="checkmark">\r\n          <li><span>Advanced Sorting Rules</span></li>\r\n          <li><span>Custom Article Configuration</span></li>\r\n          <li><span>RokGallery/MediaManager Support</span></li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n  <p>To learn more about the implementation details of supporting responsive design for RocketTheme''s Extensions, please visit the following link.</p>\r\n  <a href="http://www.rockettheme.com/blog/team/1555-responsive-design-rocketthemes-extensions" target="_blank" class="readon"><span class="icon-external-link"></span><span>Responsive Design: Part 3 - RocketTheme''s Extensions</span></a>        \r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-25 rt-block box4">\r\n  <div class="rt-demo-space">\r\n    <h4>Mobile Touch Events</h4>\r\n    <p class="rt-extra-desc">From the very genesis of it''s development, <strong>RokSprocket</strong> was designed with responsive layouts in mind. We also implemented <strong>touch events</strong> to allow you to ''swipe'' to change tabs, headlines, features and lists. This makes RokSprocket an <strong>excellent solution</strong> for <strong>responsive</strong> site building.</p>\r\n    <div class="rt-image largemargintop">\r\n      <img src="images/rocketlauncher/extensions/swipe.png" alt="image" />\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div><br />\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/extensions/ext-roksprocket-2.png" alt="image" />\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/extensions/ext-roksprocket-3.png" alt="image" />\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="rt-demo-width-33">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/extensions/ext-roksprocket-4.png" alt="image" />\r\n    </div>\r\n  </div>\r\n</div>\r\n\r\n<div class="clear"></div><br />', 1, 'showcase-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(160, 0, 'RokGallery', '', '<div class="rt-center"><p>RokGallery is a gallery extension, developed to be hugely flexible, versatile and user friendly, featured with built-in system on a custom tag-based architecture with the ability to have multiple tag-based galleries.</p>\r\n<a class="readon" href="http://www.rockettheme.com/extensions-joomla/rokgallery" target="_blank">Download: RokGallery</a></div>', 1, 'utility-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title1 icon-picture","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(161, 0, 'RokTwittie', '', '<p>RokTwittie is a highly configurable module that integrates Twitter into your Joomla site. Display tweets of any username, or even by search terms, as well as your profile information and various other elements from Twitter itself.</p>\r\n<div class="rt-demo-visible-wide"><br /></div>\r\n<a class="readon" href="http://www.rockettheme.com/extensions-joomla/roktwittie" target="_blank">Download: RokTwittie</a>', 1, 'utility-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-twitter","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(162, 0, 'K2 (3rd Party)', '', '<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/extensions/ext-k2-1.png" alt="image" />\r\n    </div>\r\n  </div>\r\n</div>\r\n<div class="rt-demo-width-50">\r\n  <div class="rt-demo-space">\r\n    <div class="rt-image">\r\n      <img src="images/rocketlauncher/extensions/ext-k2-2.png" alt="image" />\r\n    </div>\r\n  </div> \r\n</div>\r\n\r\n<div class="clear"></div>\r\n\r\n<div class="rt-demo-space">\r\n  <p>K2 is the popular powerful content extension for Joomla! with CCK-like features. The version used in this Demo site is <strong>2.5.7</strong>. K2 was built as a complete replacement of the default article system in Joomla!. Install it like any Joomla! extension, import your articles from the default Joomla! article system and you instantly get a host of new features for your existing content.</p>\r\n  <p class="alert">The 3rd party component K2 is NOT included in RocketLauncher. You will need to download them from <a target="_blank" href="http://getk2.org/">Get K2</a> and configure them on your site.</p>\r\n</div>', 1, 'maintop-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4 rt-center","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(163, 0, 'FP Slideshow - RokSprocket Features', '', '', 1, 'slideshow', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 0, '{"provider":"joomla","layout":"features","joomla_articles":{"1":{"root":{"article":"1"}},"2":{"root":{"article":"6"}},"3":{"root":{"article":"10"}}},"joomla_sort":"automatic","joomla_sort_manual_append":"after","tabs_themes":"default","mosaic_themes":"default","headlines_themes":"default","lists_themes":"default","display_limit":"\\u221e","lists_enable_accordion":"1","tabs_position":"top","headlines_label_text":"","features_themes":"slideshow","lists_previews_length":"20","features_show_title":"1","tabs_animation":"slideandfade","headlines_previews_length":"20","lists_strip_html_tags":"1","tabs_autoplay":"0","lists_items_per_page":"5","features_show_article_text":"1","headlines_show_arrows":"show","mosaic_columns":"3","features_previews_length":"\\u221e","features_strip_html_tags":"0","mosaic_previews_length":"20","headlines_animation":"slideandfade","tabs_autoplay_delay":"5","features_show_arrows":"show","lists_show_arrows":"show","mosaic_strip_html_tags":"1","features_show_pagination":"1","mosaic_items_per_page":"5","headlines_autoplay":"0","lists_show_pagination":"1","tabs_resize_enable":"0","tabs_resize_width":"0","tabs_resize_height":"0","features_animation":"crossfade","lists_autoplay":"0","tabs_previews_length":"0","mosaic_article_details":"0","headlines_autoplay_delay":"5","features_autoplay":"0","lists_autoplay_delay":"5","tabs_strip_html_tags":"0","mosaic_animations":["fade","scale","rotate"],"headlines_resize_enable":"0","headlines_resize_width":"0","headlines_resize_height":"0","mosaic_ordering":["default","title","date","random"],"features_autoplay_delay":"5","lists_resize_enable":"0","lists_resize_width":"0","lists_resize_height":"0","features_resize_enable":"0","features_resize_width":"0","features_resize_height":"0","headlines_description_default":"primary","headlines_image_default":"primary","tabs_title_default":"title","features_title_default":"title","lists_title_default":"title","features_description_default":"primary","headlines_image_default_custom":"","tabs_icon_default":"primary","lists_image_default":"primary","lists_description_default":"primary","features_image_default":"primary","lists_image_default_custom":"","tabs_icon_default_custom":"","headlines_link_default":"primary","features_image_default_custom":"","lists_link_default":"primary","headlines_link_default_custom":"","tabs_link_default":"primary","lists_link_default_custom":"","tabs_link_default_custom":"","features_link_default":"primary","features_link_default_custom":"","mosaic_resize_enable":"0","mosaic_resize_width":"0","mosaic_resize_height":"0","mosaic_title_default":"title","tabs_description_default":"primary","mosaic_description_default":"primary","mosaic_image_default":"primary","mosaic_image_default_custom":"","mosaic_link_default":"primary","mosaic_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(164, 0, 'Gantry.', '', '<div class="rt-center">\r\n  <p class="promo1">is a comprehensive set of building blocks to enable rapid development ...</p>\r\n  <a class="readon" href="index.php?option=com_content&amp;view=article&amp;id=6&amp;Itemid=113">Read More</a>\r\n</div>', 1, 'feature-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title3","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(165, 0, '[title1]Popular Features.[/title1][title2]RokSprocket and K2[/title2]', '', '', 1, 'utility-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 1, '{"provider":"joomla","layout":"mosaic","joomla_filters":{"1":{"root":{"category":"13"}}},"joomla_sort":"automatic","joomla_sort_manual_append":"after","tabs_themes":"default","mosaic_themes":"default","headlines_themes":"default","lists_themes":"default","display_limit":"\\u221e","lists_enable_accordion":"1","tabs_position":"top","headlines_label_text":"","features_themes":"slideshow","lists_previews_length":"20","features_show_title":"1","tabs_animation":"slideandfade","headlines_previews_length":"20","lists_strip_html_tags":"1","tabs_autoplay":"0","lists_items_per_page":"5","features_show_article_text":"1","headlines_show_arrows":"show","mosaic_columns":"4","features_previews_length":"\\u221e","features_strip_html_tags":"1","mosaic_previews_length":"20","headlines_animation":"slideandfade","tabs_autoplay_delay":"5","features_show_arrows":"show","lists_show_arrows":"show","mosaic_strip_html_tags":"1","features_show_pagination":"1","mosaic_items_per_page":"8","headlines_autoplay":"0","lists_show_pagination":"1","tabs_resize_enable":"0","tabs_resize_width":"0","tabs_resize_height":"0","features_animation":"crossfade","lists_autoplay":"0","tabs_previews_length":"0","mosaic_article_details":"0","headlines_autoplay_delay":"5","features_autoplay":"1","lists_autoplay_delay":"5","tabs_strip_html_tags":"0","mosaic_animations":["fade","scale","rotate"],"headlines_resize_enable":"0","headlines_resize_width":"0","headlines_resize_height":"0","mosaic_ordering":["default","title","date","random"],"features_autoplay_delay":"5","lists_resize_enable":"0","lists_resize_width":"0","lists_resize_height":"0","features_resize_enable":"0","features_resize_width":"0","features_resize_height":"0","headlines_description_default":"primary","headlines_image_default":"primary","tabs_title_default":"title","features_title_default":"title","lists_title_default":"title","features_description_default":"primary","headlines_image_default_custom":"","tabs_icon_default":"primary","lists_image_default":"primary","lists_description_default":"primary","features_image_default":"primary","lists_image_default_custom":"","tabs_icon_default_custom":"","headlines_link_default":"primary","features_image_default_custom":"","lists_link_default":"primary","headlines_link_default_custom":"","tabs_link_default":"primary","lists_link_default_custom":"","tabs_link_default_custom":"","features_link_default":"primary","features_link_default_custom":"","mosaic_resize_enable":"0","mosaic_resize_width":"0","mosaic_resize_height":"0","mosaic_title_default":"title","tabs_description_default":"primary","mosaic_description_default":"primary","mosaic_image_default":"primary","mosaic_image_default_custom":"","mosaic_link_default":"custom","mosaic_link_default_custom":"index.php?option=com_content&view=article&id=1&Itemid=108","cache":"0","moduleclass_sfx":"title1 icon-star","module_cache":"1","cache_time":"900"}', 0, '*'),
(166, 0, 'Top Features.', '', '<p><a href="index.php?option=com_content&amp;view=article&amp;id=6&amp;Itemid=113"><em class="bold">Responsive Layout:</em></a> Based on Twitter''s Bootstrap Framework, with its collection of utility classes, to provide a flexible structure.</p>\r\n\r\n<p><a href="index.php?option=com_content&amp;view=article&amp;id=6&amp;Itemid=113"><em class="bold">More with LESS.</em></a> Built-in LESS CSS compilation increased performance whilst making CSS development easier and intuitive.</p>\r\n\r\n<a class="readon" href="http://www.gantry-framework.org/documentation/joomla/basics/key-features" target="_blank"><span>More Features</span></a>', 1, 'footer-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-heart hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(168, 0, 'Contact Us.', '', '<div class="rt-demo-width-10">\r\n	<span class="icon-phone largemarginbottom largepaddingbottom"></span>\r\n</div>\r\n<div class="rt-demo-width-90">\r\n	<a href="#"><em class="bold">+1 (555) 555-555-5555</em></a><br />\r\n	<span><em class="bold nobold">+1 (555) 555-555-5556</em></span>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div>\r\n\r\n<div class="rt-demo-width-10">\r\n	<span class="icon-home largemarginbottom largepaddingbottom"></span>\r\n</div>\r\n<div class="rt-demo-width-90">\r\n	<a href="#"><em class="bold"><strong>Fracture Template LLC</strong></em></a><br />\r\n	<em class="bold nobold">\r\n	  123 Joomla! Boulevard<br />\r\n	  Seattle, WA 00000<br />\r\n	  United States of America\r\n	</em>\r\n</div>\r\n\r\n<div class="clear largemarginbottom">&nbsp;</div>\r\n\r\n<div class="rt-demo-width-10">\r\n	<span class="icon-envelope-alt largemarginbottom largepaddingbottom"></span>\r\n</div>\r\n<div class="rt-demo-width-90">\r\n	<em class="bold">noreply@domain.com</em>\r\n</div>\r\n', 1, 'footer-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-info-sign hidden-phone","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(169, 0, 'Fracture Info.', '', '<p class="medmarginbottom"><a href="http://www.rockettheme.com/joomla-templates/fracture" target="_blank"><em class="bold">Fracture</em></a> is the first RocketTheme template to be built on the Gantry4 Framework, which features a responsive layout core, a rejuvenated administrative interface and optimized coding.</p>\r\n\r\n<p class="promo3 rt-demo-visible-wide">Inside Fracture.</p>\r\n\r\n<ul class="checkmark smallmargintop">\r\n  <li class="smallmarginbottom"><a href="index.php?option=com_content&amp;view=article&amp;id=1&amp;Itemid=108"><em class="bold">Template Features</em></a></li>\r\n  <li class="smallmarginbottom"><a href="index.php?option=com_content&amp;view=article&amp;id=2&amp;Itemid=109"><em class="bold">Module Positions</em></a></li>\r\n  <li class="nomarginbottom"><a href="index.php?option=com_content&amp;view=article&amp;id=3&amp;Itemid=110"><em class="bold">Module Variations</em></a></li>\r\n</ul>', 1, 'footer-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-star","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(171, 0, 'title2 icon-star', '', '<p>An example module using the <strong>title2 icon-star</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet donec.</p>', 2, 'content-bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2 icon-star","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(172, 0, 'title2', '', '<p>An example module using the <strong>title2</strong> module suffix.</p>\r\n\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>', 2, 'content-bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title2","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(173, 0, 'box4 title1', '', '<p>An example module using the <strong>box4 title1</strong> module suffix.</p>\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>\r\n<a href="#" class="readon"><span>More</span></a>', 16, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box4 title1","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(174, 0, 'box2 title4', '', '<p>An example module using the <strong>box2 title4</strong> module suffix.</p>\r\n<p>Lorem ipsum dolor sit amet, consecetur adipiscing elit. Donec sit amet nibh.</p>\r\n<a href="#" class="readon"><span>More</span></a>', 13, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"box2 title4","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(79, 0),
(86, 0),
(92, 0),
(93, 0),
(94, 108),
(95, 109),
(96, 109),
(97, 109),
(98, 109),
(99, 109),
(100, 110),
(101, 110),
(102, 110),
(103, 110),
(104, 110),
(105, 110),
(106, 110),
(107, 110),
(108, 110),
(110, 110),
(111, 110),
(113, 110),
(114, 110),
(115, 110),
(116, 111),
(117, 111),
(118, 112),
(119, 112),
(120, 112),
(121, 112),
(122, 112),
(123, 112),
(124, 112),
(125, 113),
(126, 114),
(126, 118),
(126, 123),
(126, 125),
(127, 114),
(127, 118),
(127, 123),
(127, 125),
(128, 114),
(129, 114),
(130, 114),
(131, 114),
(132, 114),
(132, 116),
(132, 118),
(132, 123),
(132, 124),
(132, 125),
(133, 114),
(133, 116),
(133, 118),
(133, 123),
(133, 124),
(133, 125),
(134, 114),
(134, 116),
(134, 118),
(134, 123),
(134, 124),
(134, 125),
(135, 115),
(136, 115),
(137, 112),
(137, 115),
(137, 116),
(137, 117),
(137, 118),
(137, 124),
(138, 112),
(138, 115),
(138, 116),
(138, 117),
(138, 118),
(139, 115),
(140, 115),
(141, 117),
(142, 117),
(143, 117),
(144, 123),
(145, 123),
(146, 124),
(147, 125),
(148, 124),
(149, 116),
(150, 115),
(151, 112),
(151, 117),
(151, 118),
(151, 123),
(151, 124),
(152, 108),
(153, 108),
(154, 108),
(155, 108),
(156, 108),
(157, 113),
(158, 113),
(159, 113),
(160, 113),
(161, 113),
(162, 113),
(163, 101),
(164, 101),
(165, 101),
(166, 101),
(168, 101),
(169, 101),
(171, 110),
(172, 110),
(173, 110),
(174, 110);

-- --------------------------------------------------------

--
-- Table structure for table `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(200) NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` text NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__overrider`
--

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` text NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__postinstall_messages`
--

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE IF NOT EXISTS `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) NOT NULL DEFAULT '',
  `language_extension` varchar(255) NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__postinstall_messages`
--

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(3, 700, 'PLG_USER_JOOMLA_POSTINSTALL_STRONGPW_TITLE', 'PLG_USER_JOOMLA_POSTINSTALL_STRONGPW_TEXT', 'PLG_USER_JOOMLA_POSTINSTALL_STRONGPW_BTN', 'plg_user_joomla', 1, 'action', 'site://plugins/user/joomla/postinstall/actions.php', 'plguserjoomla_postinstall_action', 'site://plugins/user/joomla/postinstall/actions.php', 'plguserjoomla_postinstall_condition', '3.2.0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__rokcandy`
--

DROP TABLE IF EXISTS `#__rokcandy`;
CREATE TABLE IF NOT EXISTS `#__rokcandy` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL,
  `macro` text NOT NULL,
  `html` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `checked_out` int(11) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `ordering` int(11) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__rokcandy`
--

INSERT INTO `#__rokcandy` (`id`, `catid`, `macro`, `html`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`) VALUES
(20, 8, '[h1]{text}[/h1]', '<h1>{text}</h1>', 1, 0, '0000-00-00 00:00:00', 1, ''),
(21, 8, '[h2]{text}[/h2]', '<h2>{text}</h2>', 1, 0, '0000-00-00 00:00:00', 2, ''),
(22, 8, '[h3]{text}[/h3]', '<h3>{text}</h3>', 1, 0, '0000-00-00 00:00:00', 3, ''),
(23, 8, '[h4]{text}[/h4]', '<h4>{text}</h4>', 1, 0, '0000-00-00 00:00:00', 4, ''),
(24, 8, '[h5]{text}[/h5]', '<h5>{text}</h5>', 1, 0, '0000-00-00 00:00:00', 5, ''),
(25, 8, '[b]{text}[/b]', '<strong>{text}</strong>', 1, 0, '0000-00-00 00:00:00', 6, ''),
(26, 8, '[i]{text}[/i]', '<em>{text}</em>', 1, 0, '0000-00-00 00:00:00', 7, ''),
(27, 8, '[code]{text}[/code]', '<code>{text}</code>', 1, 0, '0000-00-00 00:00:00', 8, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__rokcommon_configs`
--

DROP TABLE IF EXISTS `#__rokcommon_configs`;
CREATE TABLE IF NOT EXISTS `#__rokcommon_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extension` varchar(45) NOT NULL DEFAULT '',
  `type` varchar(45) NOT NULL,
  `file` varchar(256) NOT NULL,
  `priority` int(10) NOT NULL DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__rokcommon_configs`
--

INSERT INTO `#__rokcommon_configs` (`id`, `extension`, `type`, `file`, `priority`) VALUES
(1, 'rokgallery', 'container', '/components/com_rokgallery/container.xml', 10),
(2, 'rokgallery', 'library', '/components/com_rokgallery/lib', 10),
(3, 'roksprocket', 'container', '/components/com_roksprocket/container.xml', 10),
(4, 'roksprocket', 'library', '/components/com_roksprocket/lib', 10);

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_files`
--

DROP TABLE IF EXISTS `#__rokgallery_files`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `guid` char(36) NOT NULL,
  `md5` char(32) NOT NULL,
  `title` varchar(200) NOT NULL,
  `description` text,
  `license` varchar(255) DEFAULT NULL,
  `xsize` int(10) unsigned NOT NULL,
  `ysize` int(10) unsigned NOT NULL,
  `filesize` int(10) unsigned NOT NULL,
  `type` char(20) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `slug` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `guid` (`guid`),
  UNIQUE KEY `#__files_sluggable_idx` (`slug`),
  KEY `#__rokgallery_files_published_idx` (`published`),
  KEY `#__rokgallery_files_md5_idx` (`md5`),
  KEY `#__rokgallery_files_guid_idx` (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_files_index`
--

DROP TABLE IF EXISTS `#__rokgallery_files_index`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_files_index` (
  `keyword` varchar(200) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `position` bigint(20) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyword`,`field`,`position`,`id`),
  KEY `#__rokgallery_files_index_id_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_file_loves`
--

DROP TABLE IF EXISTS `#__rokgallery_file_loves`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_file_loves` (
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `kount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_file_tags`
--

DROP TABLE IF EXISTS `#__rokgallery_file_tags`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_file_tags` (
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`file_id`,`tag`),
  KEY `#__rokgallery_file_tags_file_id_idx` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_file_views`
--

DROP TABLE IF EXISTS `#__rokgallery_file_views`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_file_views` (
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `kount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_filters`
--

DROP TABLE IF EXISTS `#__rokgallery_filters`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `query` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `rokgallery_profiles_name_idx` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_galleries`
--

DROP TABLE IF EXISTS `#__rokgallery_galleries`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_galleries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `filetags` longtext,
  `width` int(10) unsigned NOT NULL DEFAULT '910',
  `height` int(10) unsigned NOT NULL DEFAULT '500',
  `keep_aspect` tinyint(1) DEFAULT '0',
  `force_image_size` tinyint(1) DEFAULT '0',
  `thumb_xsize` int(10) unsigned NOT NULL DEFAULT '190',
  `thumb_ysize` int(10) unsigned NOT NULL DEFAULT '150',
  `thumb_background` varchar(12) DEFAULT NULL,
  `thumb_keep_aspect` tinyint(1) DEFAULT '0',
  `auto_publish` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `#__rokgallery_galleries_auto_publish_idx` (`auto_publish`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_jobs`
--

DROP TABLE IF EXISTS `#__rokgallery_jobs`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_jobs` (
  `id` char(36) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL,
  `properties` text,
  `state` varchar(255) NOT NULL,
  `status` text,
  `percent` bigint(20) unsigned DEFAULT NULL,
  `sm` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_profiles`
--

DROP TABLE IF EXISTS `#__rokgallery_profiles`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `profile` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `#__rokgallery_profiles_name_idx` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_schema_version`
--

DROP TABLE IF EXISTS `#__rokgallery_schema_version`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_schema_version` (
  `version` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__rokgallery_schema_version`
--

INSERT INTO `#__rokgallery_schema_version` (`version`) VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_slices`
--

DROP TABLE IF EXISTS `#__rokgallery_slices`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_slices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` int(10) unsigned NOT NULL,
  `gallery_id` int(10) unsigned DEFAULT NULL,
  `guid` char(36) NOT NULL,
  `title` varchar(200) DEFAULT NULL,
  `caption` text,
  `link` text,
  `filesize` int(10) unsigned NOT NULL,
  `xsize` int(10) unsigned NOT NULL,
  `ysize` int(10) unsigned NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `admin_thumb` tinyint(1) NOT NULL DEFAULT '0',
  `manipulations` longtext,
  `palette` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `thumb_xsize` int(10) unsigned NOT NULL,
  `thumb_ysize` int(10) unsigned NOT NULL,
  `thumb_keep_aspect` tinyint(1) NOT NULL DEFAULT '1',
  `thumb_background` varchar(12) DEFAULT NULL,
  `ordering` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `guid` (`guid`),
  UNIQUE KEY `#__rokgallery_slices_sluggable_idx` (`slug`,`gallery_id`),
  KEY `rokgallery_slices_published_idx` (`published`),
  KEY `rokgallery_slices_guid_idx` (`guid`),
  KEY `file_id_idx` (`file_id`),
  KEY `gallery_id_idx` (`gallery_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_slices_index`
--

DROP TABLE IF EXISTS `#__rokgallery_slices_index`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_slices_index` (
  `keyword` varchar(200) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `position` bigint(20) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyword`,`field`,`position`,`id`),
  KEY `rokgallery_slices_index_id_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__rokgallery_slice_tags`
--

DROP TABLE IF EXISTS `#__rokgallery_slice_tags`;
CREATE TABLE IF NOT EXISTS `#__rokgallery_slice_tags` (
  `slice_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`slice_id`,`tag`),
  KEY `rokgallery_slice_tags_slice_id_idx` (`slice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__roksprocket_items`
--

DROP TABLE IF EXISTS `#__roksprocket_items`;
CREATE TABLE IF NOT EXISTS `#__roksprocket_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(45) NOT NULL,
  `provider` varchar(45) NOT NULL,
  `provider_id` varchar(45) NOT NULL,
  `order` int(10) unsigned NOT NULL,
  `params` text,
  PRIMARY KEY (`id`),
  KEY `idx_module` (`module_id`),
  KEY `idx_module_order` (`module_id`,`order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__roksprocket_items`
--

INSERT INTO `#__roksprocket_items` (`id`, `module_id`, `provider`, `provider_id`, `order`, `params`) VALUES
(257, '163', 'joomla', '1', 0, '{"features_item_title":"Gantry 4 Template.","features_item_description":"<span>Featuring LESS, a dynamic CSS language and a Responsive Layout.<\\/span> <span class=\\"rt-demo-visible-wide\\">Read about the new features below.<\\/span>","features_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-features\\/img1.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_1__params_features_item_image''}","features_item_link":"-default-","mosaic_item_title":"-default-","tabs_item_title":"-default-","lists_item_title":"-default-","mosaic_item_description":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","mosaic_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","lists_item_link":"-default-","mosaic_item_tags":null,"headlines_item_image":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","headlines_item_description":"-default-"}'),
(258, '163', 'joomla', '6', 1, '{"features_item_title":"Style for Extensions.","features_item_description":"<span>Fracture specific styling for K2, RokSprocket and RokGallery.<\\/span> <span class=\\"rt-demo-visible-wide\\">K2 is a third party CCK extension.<\\/span>","features_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-features\\/img2.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_6__params_features_item_image''}","features_item_link":"-default-","mosaic_item_title":"-default-","tabs_item_title":"-default-","lists_item_title":"-default-","mosaic_item_description":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","mosaic_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","lists_item_link":"-default-","mosaic_item_tags":null,"headlines_item_image":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","headlines_item_description":"-default-"}'),
(259, '163', 'joomla', '10', 2, '{"features_item_title":"Lots of Variants.","features_item_description":"<span>Choose from an assortment of eight configurable preset style variations.<\\/span> <span class=\\"rt-demo-visible-wide\\">Module suffixes also present.<\\/span>","features_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-features\\/img3.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_10__params_features_item_image''}","features_item_link":"-default-","mosaic_item_title":"-default-","tabs_item_title":"-default-","lists_item_title":"-default-","mosaic_item_description":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","mosaic_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","lists_item_link":"-default-","mosaic_item_tags":null,"headlines_item_image":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","headlines_item_description":"-default-"}'),
(276, '165', 'joomla', '20', 0, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img1.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_20__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"elegant, creative","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(277, '165', 'joomla', '21', 1, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img2.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_21__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"creative, powerful","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(278, '165', 'joomla', '22', 2, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img3.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_22__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"powerful, elegant","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(279, '165', 'joomla', '23', 3, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img4.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_23__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"elegant, creative","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(280, '165', 'joomla', '24', 4, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img5.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_24__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"creative, powerful","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(281, '165', 'joomla', '25', 5, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img6.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_25__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"powerful, elegant","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(282, '165', 'joomla', '26', 6, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img7.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_26__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"elegant, creative","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(283, '165', 'joomla', '27', 7, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img8.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_27__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"creative, powerful","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(284, '165', 'joomla', '28', 8, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img9.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_28__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"powerful, elegant","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(285, '165', 'joomla', '29', 9, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img10.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_29__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"elegant, creative","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(286, '165', 'joomla', '30', 10, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img11.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_30__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"creative,powerful","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(287, '165', 'joomla', '31', 11, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img12.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_31__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"powerful,elegant","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(288, '165', 'joomla', '32', 12, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img13.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_32__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"elegant,creative,powerful","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(289, '165', 'joomla', '33', 13, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img14.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_33__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"creative,powerful,elegant","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(290, '165', 'joomla', '34', 14, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img15.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_34__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"powerful,elegant,creative","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(291, '165', 'joomla', '35', 15, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/rocketlauncher\\/frontpage\\/roksprocket-mosaic\\/img16.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_35__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"elegant,creative,powerful","tabs_item_title":"-default-","lists_item_title":"-default-","tabs_item_icon":"-default-","lists_item_image":"-default-","tabs_item_link":"-default-","tabs_item_description":"-default-","lists_item_link":"-default-","features_item_title":"-default-","headlines_item_image":"-default-","features_item_description":"-default-","lists_item_description":"-default-","headlines_item_link":"-default-","features_item_image":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}');

-- --------------------------------------------------------

--
-- Table structure for table `#__tags`
--

DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE IF NOT EXISTS `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__tags`
--

INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES
(1, 0, 0, 1, 0, '', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 0, '2011-01-01 00:00:01', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__template_styles`
--

DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE IF NOT EXISTS `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_home` (`home`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__template_styles`
--

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES

(5, 'hathor', 1, '0', 'Hathor - Default', '{"showSiteName":"0","colourChoice":"","boldText":"0"}'),
(7, 'rt_fracture', 0, '1', 'rt_fracture - Default', '{"master":"true","current_id":"7","template_full_name":"Fracture","grid_system":"12","template_prefix":"fracture-","cookie_time":"31536000","name":"Preset1","copy_lang_files_if_diff":"1","main":{"accent":"#00A1FF","body":"light","mask":"horizontal"},"menutab":{"color1":"#404040","color3":"#19BAFB","color5":"#FF0117","color2":"#000000","color4":"#188FD6","color6":"#E20014"},"loadtransition":"0","font":{"family":"s:fracture","size":"default","size-is":"default"},"viewswitcher-priority":"1","logo-priority":"2","copyright-priority":"3","styledeclaration-priority":"4","date-priority":"6","fontsizer-priority":"7","totop-priority":"8","systemmessages-priority":"9","morearticles-priority":"12","smartload-priority":"13","pagesuffix-priority":"14","resetsettings-priority":"15","analytics-priority":"16","fusionmenu-priority":"18","jstools-priority":"21","moduleoverlays-priority":"22","rtl-priority":"23","splitmenu-priority":"24","styledeclaration-enabled":"1","logo":{"enabled":"1","position":"navigation-a","type":"fracture","custom":{"image":""}},"social":{"enabled":"1","position":"copyright-c","twitter":"https:\\/\\/twitter.com\\/rockettheme","facebook":"http:\\/\\/www.facebook.com\\/RocketTheme","google":"https:\\/\\/plus.google.com\\/114430407008695950828\\/posts","rss":"http:\\/\\/www.rockettheme.com\\/blog?format=feed&amp;type=rss"},"date":{"enabled":"0","position":"utility-a","clientside":"0","formats":"%A, %B %d, %Y"},"fontsizer":{"enabled":"0","position":"utility-b"},"login":{"enabled":"0","position":"utility-c","text":"Member Login","logouttext":"Logout"},"popup":{"enabled":"0","position":"utility-d","text":"Popup Module","width":"250","height":"235"},"branding":{"enabled":"0","position":"copyright-c"},"copyright":{"enabled":"1","position":"copyright-a","text":"Designed by RocketTheme","layout":"a:1:{i:12;a:1:{i:4;a:4:{i:0;i:3;i:1;i:4;i:2;i:3;i:3;i:2;}}}","showall":"0","showmax":"6"},"smartload":{"enabled":"0","text":"200","ignores":"com_community,com_contact,com_k2,com_tienda,com_weblinks","exclusion":""},"morearticles":{"enabled":"0","text":"Load More Articles","pagination":"1"},"totop":{"enabled":"1","position":"copyright-d"},"systemmessages":{"enabled":"1","position":"drawer"},"resetsettings":{"enabled":"0","position":"footer-b","text":"Reset Settings"},"analytics":{"enabled":"0","code":"","position":"analytics"},"menu":{"enabled":"1","type":"fusionmenu","fusionmenu":{"menutype":"mainmenu","position":"navigation-b","enable_menu_count":"1","enable_js":"1","opacity":"1","effect":"slidefade","hidedelay":"500","menu-animation":"Circ.easeOut","menu-duration":"300","centered-offset":"0","tweak-initial-x":"-8","tweak-initial-y":"-10","tweak-subsequent-x":"-8","tweak-subsequent-y":"-11","tweak-width":"18","tweak-height":"20","enable-current-id":"0","theme":"gantry-fusion","limit_levels":"0","startLevel":"0","showAllChildren":"1","class_sfx":"top","cache":"0","module_cache":"1"},"splitmenu":{"roknavmenu_fusion_enable-current-id":"0","menutype":"mainmenu","theme":"gantry-splitmenu","cache":"0","module_cache":"1","mainmenu-position":"navigation-b","enable_menu_count":"1","mainmenu-limit_levels":"1","mainmenu-startLevel":"0","mainmenu-endLevel":"0","mainmenu-class_sfx":"top","submenu-position":"sidebar-a","submenu-title":"1","submenu-limit_levels":"1","submenu-startLevel":"1","submenu-endLevel":"9","submenu-module_sfx":"box3","submenu-class_sfx":""}},"top":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"header":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"navigation":{"layout":"a:1:{i:12;a:1:{i:2;a:2:{i:0;i:3;i:1;i:9;}}}","showall":"0","showmax":"6"},"showcase":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"feature":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"utility":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"maintop":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"mainbodyPosition":"a:1:{i:12;a:2:{i:1;a:1:{s:2:\\"mb\\";i:12;}i:2;a:2:{s:2:\\"mb\\";i:8;s:2:\\"sa\\";i:4;}}}","mainbottom":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"extension":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"bottom":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"footer":{"layout":"3,3,3,3","showall":"0","showmax":"6"},"layout-mode":"responsive","component-enabled":"1","mainbody-enabled":"1","rtl-enabled":"1","pagesuffix-enabled":"1","typography":{"enabled":"1","style":"light"},"selectivizr-enabled":"0","less":{"compression":"1","compilewait":"2","debugheader":"0"},"k2":"0","ie7splash-enabled":"1"}'),
(8, 'rt_fracture', 0, '0', 'rt_fracture - Module Positions', '{"master":"7","current_id":"8","mainbodyPosition":"a:1:{i:12;a:2:{i:1;a:1:{s:2:\\"mb\\";i:12;}i:2;a:2:{s:2:\\"mb\\";i:6;s:2:\\"sa\\";i:6;}}}"}'),
(9, 'rt_fracture', 0, '0', 'rt_fracture - Module Variations', '{"master":"7","current_id":"9","mainbodyPosition":"a:1:{i:12;a:2:{i:1;a:1:{s:2:\\"mb\\";i:12;}i:2;a:2:{s:2:\\"mb\\";i:8;s:2:\\"sa\\";i:4;}}}"}'),
(10, 'protostar', 0, '0', 'protostar - Default', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}'),
(11, 'isis', 1, '1', 'isis - Default', '{"templateColor":"","logoFile":""}'),
(12, 'beez3', 0, '0', 'beez3 - Default', '{"wrapperSmall":53,"wrapperLarge":72,"logo":"","sitetitle":"","sitedescription":"","navposition":"center","bootstrap":"","templatecolor":"nature","headerImage":"","backgroundcolor":"#eee"}');

-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_base`
--

DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE IF NOT EXISTS `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_content`
--

DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE IF NOT EXISTS `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(255) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(255) NOT NULL,
  `core_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `core_body` mediumtext NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) NOT NULL DEFAULT '',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) NOT NULL,
  `core_publish_up` datetime NOT NULL,
  `core_publish_down` datetime NOT NULL,
  `core_content_item_id` int(10) unsigned DEFAULT NULL COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned DEFAULT NULL COMMENT 'FK to the #__assets table.',
  `core_images` text NOT NULL,
  `core_urls` text NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text NOT NULL,
  `core_metadesc` text NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains core content data in name spaced fields';

-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_history`
--

DROP TABLE IF EXISTS `#__ucm_history`;
CREATE TABLE IF NOT EXISTS `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__update_sites`
--

DROP TABLE IF EXISTS `#__update_sites`;
CREATE TABLE IF NOT EXISTS `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` text NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__update_sites`
--

INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`) VALUES
(1, 'Joomla Core', 'collection', 'http://update.joomla.org/core/sts/list_sts.xml', 1, 0, ''),
(2, 'Joomla Extension Directory', 'collection', 'http://update.joomla.org/jed/list.xml', 1, 0, ''),
(3, 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist_3.xml', 1, 0, ''),
(4, 'RocketTheme Update Directory', 'collection', 'http://updates.rockettheme.com/joomla/updates.xml', 1, 0, ''),
(5, 'Gantry Framework Update Site', 'extension', 'http://www.gantry-framework.org/updates/joomla16/gantry.xml', 1, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__update_sites_extensions`
--

DROP TABLE IF EXISTS `#__update_sites_extensions`;
CREATE TABLE IF NOT EXISTS `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__update_sites_extensions`
--

INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES
(1, 700),
(2, 700),
(3, 600),
(4, 10013),
(4, 10015),
(4, 10031),
(4, 10033),
(4, 10040),
(5, 10001);

-- --------------------------------------------------------

--
-- Table structure for table `#__viewlevels`
--

DROP TABLE IF EXISTS `#__viewlevels`;
CREATE TABLE IF NOT EXISTS `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__viewlevels`
--

INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES
(1, 'Public', 0, '[1]'),
(2, 'Registered', 1, '[6,2,8]'),
(3, 'Special', 2, '[6,3,8]');

-- --------------------------------------------------------

--
-- Table structure for table `#__weblinks`
--

DROP TABLE IF EXISTS `#__weblinks`;
CREATE TABLE IF NOT EXISTS `#__weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `images` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__weblinks`
--

INSERT INTO `#__weblinks` (`id`, `catid`, `title`, `alias`, `url`, `description`, `hits`, `state`, `checked_out`, `checked_out_time`, `ordering`, `access`, `params`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `images`) VALUES
(1, 14, 'Joomla Template', 'joomla-template', 'http://www.rockettheme.com/joomla', '', 1, 1, 0, '0000-00-00 00:00:00', 1, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-08-09 12:08:02', 402, '', '2012-08-09 12:08:09', 977, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, ''),
(2, 14, 'Wordpress Theme', 'wordpress-theme', 'http://www.rockettheme.com/wordpress', '', 0, 1, 0, '0000-00-00 00:00:00', 2, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-08-09 12:10:22', 402, '', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, ''),
(3, 14, 'phpBB3 Style', 'phpbb3-style', 'http://www.rockettheme.com/phpbb3', '', 0, 1, 0, '0000-00-00 00:00:00', 3, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-08-09 12:10:32', 402, '', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, ''),
(4, 14, 'Magento Template', 'magento-template', 'http://www.rockettheme.com/magento', '', 0, 1, 0, '0000-00-00 00:00:00', 4, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-08-09 12:10:37', 402, '', '0000-00-00 00:00:00', 0, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, '');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `#__rokgallery_files_index`
--
ALTER TABLE `#__rokgallery_files_index`
  ADD CONSTRAINT `#__rokgallery_files_index_id_idx` FOREIGN KEY (`id`) REFERENCES `#__rokgallery_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `#__rokgallery_file_loves`
--
ALTER TABLE `#__rokgallery_file_loves`
  ADD CONSTRAINT `#__file_loves_file_id_files_id` FOREIGN KEY (`file_id`) REFERENCES `#__rokgallery_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `#__rokgallery_file_tags`
--
ALTER TABLE `#__rokgallery_file_tags`
  ADD CONSTRAINT `#__file_tags_file_id_files_id` FOREIGN KEY (`file_id`) REFERENCES `#__rokgallery_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `#__rokgallery_file_views`
--
ALTER TABLE `#__rokgallery_file_views`
  ADD CONSTRAINT `#__file_views_file_id__files_id` FOREIGN KEY (`file_id`) REFERENCES `#__rokgallery_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `#__rokgallery_slices`
--
ALTER TABLE `#__rokgallery_slices`
  ADD CONSTRAINT `#__slices_file_id_files_id` FOREIGN KEY (`file_id`) REFERENCES `#__rokgallery_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `#__slices_gallery_id_galleries_id` FOREIGN KEY (`gallery_id`) REFERENCES `#__rokgallery_galleries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `#__rokgallery_slices_index`
--
ALTER TABLE `#__rokgallery_slices_index`
  ADD CONSTRAINT `#__rokgallery_slices_index_id_idx` FOREIGN KEY (`id`) REFERENCES `#__rokgallery_slices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `#__rokgallery_slice_tags`
--
ALTER TABLE `#__rokgallery_slice_tags`
  ADD CONSTRAINT `#__slice_tags_slice_id_slices_id` FOREIGN KEY (`slice_id`) REFERENCES `#__rokgallery_slices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;