<?php
/**
* @version   $Id: styledeclaration.php 10191 2013-05-10 18:47:10Z kevin $
* @author    RocketTheme http://www.rockettheme.com
* @copyright Copyright (C) 2007 - 2014 RocketTheme, LLC
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*
* Gantry uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
*
*/
defined('JPATH_BASE') or die();

gantry_import('core.gantryfeature');

class GantryFeatureStyleDeclaration extends GantryFeature {
    var $_feature_name = 'styledeclaration';

    function isEnabled() {
        /** @var $gantry Gantry */
        global $gantry;
        $menu_enabled = $this->get('enabled');

        if (1 == (int)$menu_enabled) return true;
        return false;
    }

function init() {
        /** @var $gantry Gantry */
        global $gantry;
		$browser = $gantry->browser;

	// Colors

    $css = 'a, .sprocket-lists-title:hover, .sprocket-lists li.active .sprocket-lists-title, .horizmenu ul.menu > li a:hover, .main-body-dark #rt-copyright a:hover, .main-body-light #rt-copyright .horizmenu .module-content ul.menu > li a:hover, .main-body-light #rt-copyright .horizmenu .module-content ul.menu li .separator:hover, .main-body-light #rt-copyright .horizmenu .module-content ul.menu li .nolink:hover, .sprocket-features-title a:hover {color:'.$gantry->get('main-accent').';}'."\n";
    $css .= '.button, .readon, .readmore, button.validate, #member-profile a, #member-registration a, .formelm-buttons button, .box3.rt-block, ul.menu, .rt-totop:hover, .sprocket-headlines-navigation .arrow:hover, .layout-slideshow .sprocket-features-arrows .arrow:hover, .sprocket-lists-arrows .arrow:hover, .title1 .mod-hex, .layout-slideshow .readon:hover, .main-body-dark.logo-type-fracture .logo-color, .box3.title1 .title, .box3.title3 .title, .tags .label-info {background-color:'.$gantry->get('main-accent').';}'."\n";
    $css .= '.sprocket-mosaic-image-container:hover, .sprocket-mosaic-content:hover .sprocket-mosaic-image-container {background-color:'.$this->_RGBA($gantry->get('main-accent'), '0.7').';}'."\n";
    $css .= '.login-fields #username:focus, .login-fields #password:focus, #contact-form dd input:focus, #contact-form dd textarea:focus, #modlgn-username:focus, #modlgn-passwd:focus, input#jform_email:focus, #rokajaxsearch .inputbox:focus, #member-registration dd input:focus, #search-searchword:focus, .finder .inputbox:focus {border: 1px solid '.$gantry->get('main-accent').'; box-shadow: inset 0 1px 3px '.$this->_RGBA($gantry->get('main-accent'), '0.3').', 0 0 8px '.$this->_RGBA($gantry->get('main-accent'), '0.6').';}'."\n";
    $css .= 'body ul.checkmark li::after, body ul.circle-checkmark li::before, body ul.square-checkmark li::before, body ul.circle-small li::after, body ul.circle li::after, body ul.circle-large li::after, .sprocket-headlines-badge::after {border-color: '.$gantry->get('main-accent').';}'."\n";
    $css .= 'body ul.triangle-small li::after, body ul.triangle li::after, body ul.triangle-large li::after {border-color: transparent transparent transparent '.$gantry->get('main-accent').';}'."\n";
    $css .= '.title4 .title {border-color:'.$gantry->get('main-accent').';}'."\n";
    $css .= '.menutop li.root .item, .splitmenu .menutop li .item, .fusion-submenu-wrapper {background-color:'.$gantry->get('main-accent').';}'."\n";
    $css .= '.menutab1, .menutab7 {background-color:'.$gantry->get('menutab-color1').' !important;}'."\n";
    $css .= '.menutab2, .menutab8 {background-color:'.$gantry->get('menutab-color2').' !important;}'."\n";
    $css .= '.menutab3, .menutab9 {background-color:'.$gantry->get('menutab-color3').' !important;}'."\n";
    $css .= '.menutab4, .menutab10 {background-color:'.$gantry->get('menutab-color4').' !important;}'."\n";
    $css .= '.menutab5, .menutab11 {background-color:'.$gantry->get('menutab-color5').' !important;}'."\n";
    $css .= '.menutab6, .menutab12 {background-color:'.$gantry->get('menutab-color6').' !important;}'."\n";
    
    $browser = $gantry->browser;
    // ie.
    if ($browser->name == 'ie' && $browser->version == 8){
        $css .= '.sprocket-mosaic-content:hover .sprocket-mosaic-image-container {background-color:'.$gantry->get('main-accent').';}'."\n";
    }
    
    // Logo
    $css .= $this->buildLogo();

		$this->_disableRokBoxForiPhone();

		// Style Inclusion
	    $gantry->addInlineStyle($css);
        if ($gantry->get('typography-enabled')) $gantry->addLess('typography.less');
        if ($gantry->get('typography-enabled')) $gantry->addLess('font-awesome.less');
        if ($gantry->get('layout-mode')=="responsive") $gantry->addLess('mediaqueries.less');
        if ($gantry->get('layout-mode')=="960fixed") $gantry->addLess('960fixed.less');
        if ($gantry->get('layout-mode')=="1200fixed") $gantry->addLess('1200fixed.less');

        // Third Party (k2)
        if ($gantry->get('k2')) {
            $gantry->addLess('thirdparty-k2.less');
            $gantry->addLess('thirdparty-k2-'.$gantry->get('main-body').'.less');

            $k2css  = 'body #k2Container .k2ReadMore, body #k2Container #submitCommentButton {background-color:'.$gantry->get('main-accent').';color: #fff;font-family: "EdmondSansMedium",Helvetica,Arial,sans-serif;}'."\n";
            $k2css .= 'body #k2Container .k2ReadMore {padding: 8px 35px 7px 12px;text-transform: uppercase;display: inline-block;line-height: 1.8em;background-repeat: repeat-x;position: relative;font-weight: normal;border: none;font-size: 110%;-webkit-transition: background-color 0.1s ease-in;-moz-transition: background-color 0.1s ease-in;-o-transition: background-color 0.1s ease-in;-ms-transition: background-color 0.1s ease-in;transition: background-color 0.1s ease-in;}'."\n";
            $k2css .= 'body #k2Container .k2ReadMore:before {content: "";position: absolute;width: 23px;height: 23px;background-position: 0 -604px;top: 7px;right: 4px;font-size: 1.7em;font-weight: 100;font-family: Verdana, Geneva, sans-serif;text-shadow: 0 0 1px rgba(0,0,0,0.3);}'."\n";
            $gantry->addInlineStyle($k2css);
        }
  
	}

    function buildLogo(){
        /** @var $gantry Gantry */
        global $gantry;

        if ($gantry->get('logo-type')!="custom") return "";

        $source = $width = $height = "";

        $logo = str_replace("&quot;", '"', str_replace("'", '"', $gantry->get('logo-custom-image')));
        $data = json_decode($logo);

        if (!$data){
            if (strlen($logo)) $source = $logo;
            else return "";
        } else {
            $source = $data->path;
        }

        if (substr($gantry->baseUrl, 0, strlen($gantry->baseUrl)) == substr($source, 0, strlen($gantry->baseUrl))){
            $file = JPATH_ROOT . '/' . substr($source, strlen($gantry->baseUrl));
        } else {
            $file = JPATH_ROOT . '/' . $source;
        }

        if (isset($data->width) && isset($data->height)){
            $width = $data->width;
            $height = $data->height;
        } else {
            $size = @getimagesize($file);
            $width = $size[0];
            $height = $size[1];
        }

        if (!preg_match('/^\//', $source))
        {
            $source = JURI::root(true).'/'.$source;
        }

        $source = str_replace(' ', '%20', $source);

        $output = "";
        $output .= "#rt-logo {background: url(".$source.") 50% 0 no-repeat !important;}"."\n";
        $output .= "#rt-logo {width: ".$width."px;height: ".$height."px;}"."\n";

        $file = preg_replace('/\//i', DIRECTORY_SEPARATOR, $file);

        return (file_exists($file)) ?$output : '';
    }

    function _createGradient($direction, $from, $fromOpacity, $fromPercent, $to, $toOpacity, $toPercent){
        /** @var $gantry Gantry */
        global $gantry;
        $browser = $gantry->browser;

        $fromColor = $this->_RGBA($from, $fromOpacity);
        $toColor = $this->_RGBA($to, $toOpacity);
        $gradient = $default_gradient = '';

        $default_gradient = 'background: linear-gradient('.$direction.', '.$fromColor.' '.$fromPercent.', '.$toColor.' '.$toPercent.');';

        switch ($browser->engine) {
            case 'gecko':
                $gradient = ' background: -moz-linear-gradient('.$direction.', '.$fromColor.' '.$fromPercent.', '.$toColor.' '.$toPercent.');';
                break;

            case 'webkit':
                if ($browser->shortversion < '5.1'){

                    switch ($direction){
                        case 'top':
                            $from_dir = 'left top'; $to_dir = 'left bottom'; break;
                        case 'bottom':
                            $from_dir = 'left bottom'; $to_dir = 'left top'; break;
                        case 'left':
                            $from_dir = 'left top'; $to_dir = 'right top'; break;
                        case 'right':
                            $from_dir = 'right top'; $to_dir = 'left top'; break;
                    }
                    $gradient = ' background: -webkit-gradient(linear, '.$from_dir.', '.$to_dir.', color-stop('.$fromPercent.','.$fromColor.'), color-stop('.$toPercent.','.$toColor.'));';
                } else {
                    $gradient = ' background: -webkit-linear-gradient('.$direction.', '.$fromColor.' '.$fromPercent.', '.$toColor.' '.$toPercent.');';
                }
                break;

            case 'presto':
                $gradient = ' background: -o-linear-gradient('.$direction.', '.$fromColor.' '.$fromPercent.', '.$toColor.' '.$toPercent.');';
                break;

            case 'trident':
                if ($browser->shortversion >= '10'){
                    $gradient = ' background: -ms-linear-gradient('.$direction.', '.$fromColor.' '.$fromPercent.', '.$toColor.' '.$toPercent.');';
                } else if ($browser->shortversion <= '6'){
                    $gradient = $from;
                    $default_gradient = '';
                } else {

                    $gradient_type = ($direction == 'left' || $direction == 'right') ? 1 : 0;
                    $from_nohash = str_replace('#', '', $from);
                    $to_nohash = str_replace('#', '', $to);

                    if (strlen($from_nohash) == 3) $from_nohash = str_repeat(substr($from_nohash, 0, 1), 6);
                    if (strlen($to_nohash) == 3) $to_nohash = str_repeat(substr($to_nohash, 0, 1), 6);

                    if ($fromOpacity == 0 || $fromOpacity == '0' || $fromOpacity == '0%') $from_nohash = '00' . $from_nohash;
                    if ($toOpacity == 0 || $toOpacity == '0' || $toOpacity == '0%') $to_nohash = '00' . $to_nohash;

                    $gradient = " filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#".$to_nohash."', endColorstr='#".$from_nohash."',GradientType=".$gradient_type." );";

                    $default_gradient = '';

                }
                break;

            default:
                $gradient = $from;
                $default_gradient = '';
                break;
        }

        return  $default_gradient . $gradient;
    }

    function _HEX2RGB($hexStr, $returnAsString = false, $seperator = ','){
        $hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr);
        $rgbArray = array();

        if (strlen($hexStr) == 6){
            $colorVal = hexdec($hexStr);
            $rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
            $rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
            $rgbArray['blue'] = 0xFF & $colorVal;
        } elseif (strlen($hexStr) == 3){
            $rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
            $rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
            $rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
        } else {
            return false;
        }

        return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray;
    }

    function _RGBA($hex, $opacity){
        return 'rgba(' . $this->_HEX2RGB($hex, true) . ','.$opacity.')';
    }

	function _disableRokBoxForiPhone() {
		/** @var $gantry Gantry */
		global $gantry;

		if ($gantry->browser->platform == 'iphone' || $gantry->browser->platform == 'android') {
			$gantry->addInlineScript("window.addEvent('domready', function() {\$\$('a[rel^=rokbox]').removeEvents('click');});");
		}
	}
}
